# coding: utf-8
import logging

import sandbox.sdk2 as sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.common import task_env
from sandbox.projects.ydo import ydo_releasers
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)


class YdoOrderProcessorExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSuspiciousCalls(sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        ram = 1024
        environments = [
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        ]

    class Parameters(
        generate_view(
            ydo_order_processor=YdoOrderProcessorExecutable,
            check_owner=True,
            with_environ=True,
            default_secret_env_vars={
                'YDB_TOKEN': 'ydb-token',
            },
        )
    ):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            source_data_table = sdk2.parameters.String('Path to source data table', required=True)
        with sdk2.parameters.Group('SUSPICIOUS_CALLS'):
            backend_host = sdk2.parameters.String('Backend host', required=True)
            adminka_host = sdk2.parameters.String('Adminka host', required=True)
            samsara_api_host = sdk2.parameters.String('Samsara API host', required=True)
            samsara_queue_id = sdk2.parameters.String('Samsara queue id', required=True)

        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter=None):
        if parameter:
            cmd += [name, parameter]
        else:
            cmd.append(name)

    def on_execute(self):
        cmd = [self.Parameters.ydo_order_processor_path]

        self.add_param_to_cmd(cmd, '--kikimr-host', self.Parameters.ydb_host)
        self.add_param_to_cmd(cmd, '--kikimr-home', self.Parameters.ydb_home)
        self.add_param_to_cmd(cmd, '--kikimr-database', self.Parameters.ydb_database)
        self.add_param_to_cmd(cmd, '--kikimr-port', str(self.Parameters.ydb_port))
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))
        self.add_param_to_cmd(cmd, '--source-data', str(self.Parameters.source_data_table))

        self.add_param_to_cmd(cmd, '--suspicious-calls')
        self.add_param_to_cmd(cmd, '--backend-home-url', str(self.Parameters.backend_host))
        self.add_param_to_cmd(cmd, '--adminka-home-url', str(self.Parameters.adminka_host))
        self.add_param_to_cmd(cmd, '--samsara-api-host', str(self.Parameters.samsara_api_host))
        self.add_param_to_cmd(cmd, '--samsara-queue-id', str(self.Parameters.samsara_queue_id))

        if self.Parameters.logging_config:
            self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)

        execute_cmd(cmd, 'ydo_order_processor', 'ydo_order_processor failed', env=self.Parameters.get_environ())
