import logging
import os

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.projects.ydo import (
    execute_cmd,
    ydo_releasers,
)
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.ydo.parameters_view import generate_view, ResourceWrapper


class YdoOrdersDeficientCommissionProcessor(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/partner_flow/orders_deficient_commission_processor/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="orders_deficient_commission_proccessor")


class YdoProcessOrdersDeficientCommission(sdk2.Task):
    """Task that processes orders and performs charge offs for orders on deficient commission amount"""

    class Parameters(generate_view(
        processor=YdoOrdersDeficientCommissionProcessor,
        check_owner=True,
    )):
        ydb_host = sdk2.parameters.String('YDB Host', required=True)

        ydb_port = sdk2.parameters.Integer('YDB Port', default=2135, required=True)

        ydb_database = sdk2.parameters.String('YDB Database', required=True)

        ydb_home = sdk2.parameters.String('YDB Home', required=True)

        ydb_token = sdk2.parameters.YavSecret("YDB token in yav", required=True)

        ydo_intapi_host = sdk2.parameters.String('Ydo IntApi Host', required=True)

        tvm_id = sdk2.parameters.Integer('Ydo Tvm Id', required=True)

        tvm_secret = sdk2.parameters.YavSecret("Tvm secret in yav", required=True)

        yt_proxy = sdk2.parameters.String('YT proxy', required=True, default='hahn')

        yt_token = sdk2.parameters.YavSecret('YT token in yav', required=True)

        yt_backup_dir = sdk2.parameters.String('YT backup dir', required=True)

        minimal_order_create_date = sdk2.parameters.String('Minimal order create date in %Y-%m-%d format', required=True)

        weekday_start = sdk2.parameters.Integer('Week day when notifications starts')

        weekday_end = sdk2.parameters.Integer('Week day when notifications ends')

        hour_start = sdk2.parameters.Integer('Hour when notifications starts')

        hour_end = sdk2.parameters.Integer('Hour when notifications ends')


    class Requirements(sdk2.Requirements):
        cores = 1
        dns = ctm.DnsType.DNS64
        environments = (
            PipEnvironment('requests'),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        logging.info('Starting executing orders deficient commission processor')

        env = os.environ.copy()
        env['YDB_TOKEN'] = self.Parameters.ydb_token.data()['YDB_TOKEN']
        env['TVM_SECRET'] = self.Parameters.tvm_secret.data()['TVM_SECRET']
        env['YT_TOKEN'] = self.Parameters.yt_token.data()['YT_TOKEN']

        execute_cmd(
            [
                str(self.Parameters.processor_path),
                '--ydb-host', str(self.Parameters.ydb_host),
                '--ydb-port', str(self.Parameters.ydb_port),
                '--ydb-database', str(self.Parameters.ydb_database),
                '--ydb-home', str(self.Parameters.ydb_home),
                '--ydo-intapi-host', str(self.Parameters.ydo_intapi_host),
                '--tvm-id', str(self.Parameters.tvm_id),
                '--yt-proxy', str(self.Parameters.yt_proxy),
                '--yt-backup-dir', str(self.Parameters.yt_backup_dir),
                '--minimal-order-create-date', str(self.Parameters.minimal_order_create_date),
            ],
            'process_orders_deficient_commission',
            'Failed to process orders deficient commission',
            env=env,
        )

        logging.info('Done')
