import sandbox.projects.ydo.process_generator as process_generator


class TaskMixin(process_generator.BaseMixin):
    def get_cmd(self):
        return [
            self.get_binary_path(),
            '--config',
            self.get_config_path(),
        ]


class ProcessGenerator(process_generator.ProcessGenerator):
    TaskMixinClass = TaskMixin


pg = ProcessGenerator(
    build_binary_path='ydo/tools/partner_flow/pass_payoffs_to_partners/bin',
    binary_name='pass_payoffs_to_partners',
    config_spec=process_generator.ConfigSpec(
        'ydo/tools/partner_flow/pass_payoffs_to_partners/configs',
        [
            ('production', 'production.yaml'),
            ('testing', 'testing.yaml'),
        ],
    ),
    use_yav_secrets=False,
)


class YdoPassPayoffsToPartnersExecutable(pg.generate_resource()):
    pass


class BuildYdoPassPayoffsToPartnersExecutable(pg.generate_build_task(YdoPassPayoffsToPartnersExecutable)):
    pass


class YdoPassPayoffsToPartners(pg.generata_task(YdoPassPayoffsToPartnersExecutable)):
    pass
