import itertools
import logging

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers, execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


class YdoESSPassportCheckerExecutable(sdk2.Resource):
    """Fetch answers from ST-queue and push new issues"""
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoESSPassportChecker(sdk2.Task):
    """Task that fetches check results from ST-queue and pushes new issues"""
    class Parameters(generate_view(
        passport_checker=YdoESSPassportCheckerExecutable,
        check_owner=True,
        with_environ=True,
        default_env_vars={
            'YT_PROXY': 'hahn.yt.yandex.net',
            'YT_LOG_LEVEL': 'INFO',
        },
    )):
        ydo_tokens = sdk2.parameters.YavSecret("Ydo ydb token", required=True, default='sec-01eejahmvyzqjv50qt9smmq898')
        s3_ydo = sdk2.parameters.YavSecret("Ydo s3 secrets", required=True, default='sec-01dtsgsd0zz2ednshq0gax5mak')

        yt_backup_path = sdk2.parameters.String('Path to YDB backup', required=True)
        yt_service_squeeze_path = sdk2.parameters.String('Path to squeezed search and order clicks dir', required=True)

        yt_passport_export_dir = sdk2.parameters.String('Path to passport export for reparsing', required=False)

        priority_delta = sdk2.parameters.Integer('Number of days to take into account for workers prioritization', required=True, default=14)

        ydb_host = sdk2.parameters.String('YDB host', required=True)
        ydb_port = sdk2.parameters.Integer('YDB port', required=True, default=2135)
        ydb_database = sdk2.parameters.String('YDB database', required=True)
        ydb_home = sdk2.parameters.String('Path to YDB home dir', required=True)

        st_queue = sdk2.parameters.String('Name of Startrek queue', required=True)
        st_component = sdk2.parameters.String('Name of Startrek queue\'s component', required=True)
        st_final_tag_yes = sdk2.parameters.String('Startrek issue\'s tag YES', required=True)
        st_final_tag_maybe = sdk2.parameters.String('Startrek issue\'s tag MAYBE', required=True)
        st_final_tag_no = sdk2.parameters.String('Startrek issue\'s tag NO', required=True)
        st_final_tag_typo = sdk2.parameters.String('Startrek issue\'s tag TYPO', required=False)
        st_final_tag_black = sdk2.parameters.String('Startrek issue\'s tag BLACK', required=False)
        st_final_tag_check_failed = sdk2.parameters.String('Startrek issue\'s tag FAILED', required=True)
        st_final_status_closed_id = sdk2.parameters.String('ID of Startrek issue\'s status CLOSED', required=True)
        st_base_url = sdk2.parameters.String('Startrek base api url', required=True, default='https://st-api.yandex-team.ru')
        st_capacity = sdk2.parameters.Integer('Limit for amount of concurrent checks', required=True)
        st_relaxation_time = sdk2.parameters.Float('Time for Startrek to cool down', required=True, default=0.5)
        st_done_transition_name = sdk2.parameters.String('Move to OK queue\'s action name', required=True, default='close')
        st_done_resolution_name = sdk2.parameters.String('Move to OK queue\'s resolution name', required=True, default='fixed')
        st_need_review_transition_name = sdk2.parameters.String('Move to NEED_REVIEW queue\'s action name', required=True, default='need_info')

        mail_host = sdk2.parameters.String('Host for sending emails', required=True, default='smtp.yandex-team.ru')
        mail_port = sdk2.parameters.Integer('Port for sending emails', required=True, default=465)
        mail_login = sdk2.parameters.String('Login for sending emails', required=True, default='robot-services')
        mail_from = sdk2.parameters.String('Email FROM for sending emails', required=True, default='robot-services@yandex-team.ru')
        mail_to = sdk2.parameters.List('Email TO for sending emails', required=True)
        mail_to_expired = sdk2.parameters.List('Email TO for sending expired verdicts reports', required=False)
        mail_to_send_limit = sdk2.parameters.Integer('Max amount of messages for one email', required=True, default=100)
        mail_send_delay = sdk2.parameters.Float('Time for mail to cool down', required=True, default=4.)

        verdict_result_form_link = sdk2.parameters.String('Link to form for results', required=True)
        verdict_delay = sdk2.parameters.Integer('Time for verdict to materialize', required=True, default=60*30)

        ydo_admin_link = sdk2.parameters.String('Link to ydo admin panel', required=False)

        ts_for_skip_red_passports = sdk2.parameters.Integer('Timestamp starting from which to use last red passport to skip the check', required=True, default=1619816400)

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def proceed_passports_batch(self):
        env = self.Parameters.get_environ()
        env['YT_TOKEN'] = self.Parameters.ydo_tokens.data()['YT_TOKEN']
        env['YDB_TOKEN'] = self.Parameters.ydo_tokens.data()['YDB_TOKEN']
        env['S3_ACCESS_KEY'] = self.Parameters.s3_ydo.data()['s3_access_key']
        env['S3_SECRET_ACCESS_KEY'] = self.Parameters.s3_ydo.data()['s3_secret_access_key']
        env['SECURE_IMAGES_AES_KEY'] = self.Parameters.s3_ydo.data()['secure_images_aes_key']
        env['ST_TOKEN'] = self.Parameters.ydo_tokens.data()['ST_TOKEN']
        env['MAIL_PASSWORD'] = self.Parameters.ydo_tokens.data()['SMTP_TOKEN']

        execute_cmd(
            [
                self.Parameters.passport_checker_path,
                '--yt_backup_path', self.Parameters.yt_backup_path,
                '--yt_service_squeeze_path', self.Parameters.yt_service_squeeze_path,
                '--priority_delta', str(self.Parameters.priority_delta),
                '--ydb_host', self.Parameters.ydb_host,
                '--ydb_port', str(self.Parameters.ydb_port),
                '--ydb_database', self.Parameters.ydb_database,
                '--ydb_home', self.Parameters.ydb_home,
                '--st_queue', self.Parameters.st_queue,
                '--st_component', self.Parameters.st_component,
                '--st_final_tag_yes', self.Parameters.st_final_tag_yes,
                '--st_final_tag_maybe', self.Parameters.st_final_tag_maybe,
                '--st_final_tag_no', self.Parameters.st_final_tag_no,
                '--st_final_tag_check_failed', self.Parameters.st_final_tag_check_failed,
                '--st_final_status_closed_id', self.Parameters.st_final_status_closed_id,
                '--st_base_url', self.Parameters.st_base_url,
                '--st_capacity', str(self.Parameters.st_capacity),
                '--st_relaxation_time', str(self.Parameters.st_relaxation_time),
                '--st_done_transition_name', self.Parameters.st_done_transition_name,
                '--st_done_resolution_name', self.Parameters.st_done_resolution_name,
                '--st_need_review_transition_name', self.Parameters.st_need_review_transition_name,
                '--mail_host', self.Parameters.mail_host,
                '--mail_port', str(self.Parameters.mail_port),
                '--mail_login', self.Parameters.mail_login,
                '--mail_from', self.Parameters.mail_from,
                '--mail_send_delay', str(self.Parameters.mail_send_delay),
                '--mail_to_send_limit', str(self.Parameters.mail_to_send_limit),
                '--verdict_result_form_link', self.Parameters.verdict_result_form_link,
                '--verdict_delay', str(self.Parameters.verdict_delay),
                '--ts_for_skip_red_passports', str(self.Parameters.ts_for_skip_red_passports),
            ] + (['--ydo_admin_link', self.Parameters.ydo_admin_link] if self.Parameters.ydo_admin_link else [])
            + list(itertools.chain(*(('--mail_to', addr) for addr in self.Parameters.mail_to)))
            + list(itertools.chain(*(('--mail_to_expired', addr) for addr in self.Parameters.mail_to_expired)))
            + (['--yt_passport_export_dir', self.Parameters.yt_passport_export_dir] if self.Parameters.yt_passport_export_dir else [])
            + (['--st_final_tag_typo', self.Parameters.st_final_tag_typo] if self.Parameters.st_final_tag_typo else [])
            + (['--st_final_tag_black', self.Parameters.st_final_tag_black] if self.Parameters.st_final_tag_black else []),
            'ydo_passport_checker',
            'Failed to proceed passports batch',
            env=env
        )

    def on_execute(self):
        self.proceed_passports_batch()
        logging.info('Done')
