import logging
import os

from sandbox import sdk2

from sandbox.projects.ydo import (
    ydo_releasers,
    execute_cmd,
)

from sandbox.projects.geosearch.CleanupYtFolder import clean_folder


# Resource types
class YdoPrepDirectCertificatesDataExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoPrepDirectCertificatesData(sdk2.Task):
    class Parameters(sdk2.Parameters):
        prep_certificates = sdk2.parameters.Resource(
            'Prepare direct certificates executable',
            resource_type=YdoPrepDirectCertificatesDataExecutable,
            required=True
        )

        self_tvm_id = sdk2.parameters.String('Client TVM id', required=True)
        tvm_vault = sdk2.parameters.String('Client TVM vault name', required=True)
        exp_api_tvm_id = sdk2.parameters.String('Expert api TVM id', required=True)
        exp_api_url = sdk2.parameters.String('Expert api url', required=True)
        freelancers_path = sdk2.parameters.String('Path to freelancers table', required=True)
        res_dir = sdk2.parameters.String('Directory of resulting table', required=True)

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def create_cert_table(self):
        yt_token = sdk2.Vault.data(self.owner, 'yt-token')

        env = os.environ.copy()
        env['YT_TOKEN'] = yt_token
        env['YT_PROXY'] = 'hahn.yt.yandex.net'
        env['YT_LOG_LEVEL'] = 'INFO'

        logging.info('Start making yt table for certificates...')
        execute_cmd(
            [
                str(sdk2.ResourceData(self.Parameters.prep_certificates).path),
                '--self_tvm_id', self.Parameters.self_tvm_id,
                '--tvm_secret', sdk2.Vault.data(self.owner, self.Parameters.tvm_vault),
                '--exp_api_tvm_id', self.Parameters.exp_api_tvm_id,
                '--exp_api_url', self.Parameters.exp_api_url,
                '--freelancers_path', self.Parameters.freelancers_path,
                '--res_dir', self.Parameters.res_dir,
            ],
            'Prepare direct certificates data',
            'Failed to make certificates table',
            env=env
        )

    def on_execute(self):
        with self.memoize_stage.firststage:
            self.create_cert_table()

        with self.memoize_stage.clean_folder:
            clean_folder(self, self.Parameters.res_dir)

        logging.info('Done')
