import os

from sandbox import sdk2

from sandbox.projects.common.build.tasks.YaMakeTemplate import get_project_params

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view, with_config
from sandbox.projects.ydo.build import YdoYaMakeTemplate

from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2

import sandbox.projects.ydo.resource_types as ydo_resource_types


class ConfigSpec(object):
    def __init__(self, folder, choices, auto_post_process=False):
        self.folder = folder
        self.choices = choices
        self.auto_post_process = auto_post_process


class BaseMixin(object):
    def get_binary_path(self):
        return self.Parameters.binary_path

    def get_config_path(self):
        return self.Parameters.config_path

    def get_cmd(self):
        return [
            self.get_binary_path(),
            '--config',
            self.get_config_path(),
            '--log-to-stderr',
        ]

    def save_info_about_logs(self):
        logs_resource = sdk2.Resource.find(type='TASK_LOGS', task_id=self.id).first()
        logs = []
        for log in ('out', 'err'):
            log_file = 'run_binary.{}.log'.format(log)
            log_link = 'https://proxy.sandbox.yandex-team.ru/{resource_id}/{log_file}'.format(
                resource_id=logs_resource.id,
                log_file=log_file,
            )
            logs.append(
                '<li><a href="{log_link}">{log_file}</a></li>'.format(
                    log_link=log_link,
                    log_file=log_file,
                )
            )

        logs_str = ''.join(logs)
        self.set_info('Logs:<ul>{}</ul>'.format(logs_str), do_escape=False)

    def execute_cmd(self, cmd):
        execute_cmd(
            cmd,
            'run_binary',
            'run binary failed',
            env=self.Parameters.get_environ(),
            fail_on_error=False,
        )


class ProcessGenerator(object):
    TaskMixinClass = BaseMixin
    SolomonMixinClass = SolomonMixinV2

    def __init__(self, build_binary_path, binary_name=None, config_spec=None, use_yav_secrets=True):
        self.build_binary_path = build_binary_path
        self.binary_name = binary_name or os.path.basename(self.build_binary_path)
        assert config_spec is not None
        self.config_spec = config_spec
        self.use_yav_secrets = use_yav_secrets

    def generate_resource(self):
        class Resource(sdk2.Resource):
            __abstract__ = True
            any_arch = True
            auto_backup = True
            releasable = True
            executable = True
            releasers = ydo_resource_types.ydo_releasers + ydo_resource_types.rm_releasers
            arcadia_build_path = self.build_binary_path
            binary_path = sdk2.parameters.String(default=self.binary_name)

        return Resource

    def generate_build_task(self, resource_class):
        class BuildTask(YdoYaMakeTemplate):
            class Parameters(get_project_params([resource_class])):
                pass

        return BuildTask

    def generata_task(self, resource_class):
        parameters = self.generata_task_parameters(resource_class)
        SolomonMixinClass = self.SolomonMixinClass

        class CmdTask(sdk2.Task, self.TaskMixinClass, SolomonMixinClass):
            class Requirements(sdk2.Requirements):
                cores = 1

                class Caches(sdk2.Requirements.Caches):
                    pass

            class Parameters(parameters):
                pass

            def on_break(self, *args, **kwargs):
                self.Parameters.save_info_about_resources()
                self.save_info_about_logs()
                SolomonMixinClass.on_break(self, *args, **kwargs)
                super(CmdTask, self).on_break(*args, **kwargs)

            def on_finish(self, *args, **kwargs):
                self.Parameters.save_info_about_resources()
                self.save_info_about_logs()
                SolomonMixinClass.on_finish(self, *args, **kwargs)
                super(CmdTask, self).on_finish(*args, **kwargs)

            def on_execute(self):
                cmd = self.get_cmd()
                self.execute_cmd(cmd)

        return CmdTask

    def generata_task_parameters(self, resource_class):
        parameters = generate_view(
            binary=resource_class,
            check_owner=True,
            with_environ=True,
            use_yav_secrets=self.use_yav_secrets,
        )
        parameters = with_config(
            parameters,
            self.config_spec.folder,
            self.config_spec.choices,
            auto_post_process=self.config_spec.auto_post_process,
        )
        return parameters
