import json

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoProcessSuspendedOrderPartnersExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoProcessSuspendedOrderPartners(sdk2.Task, SolomonMixinV2):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_process_suspended_order_partners=YdoProcessSuspendedOrderPartnersExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            yt_orders = sdk2.parameters.String('YT orders path', required=True)
            yt_orders_aux = sdk2.parameters.String('YT orders_aux path', required=True)
            yt_order_partner = sdk2.parameters.String('YT order_partner path', required=True)
            yt_partner_to_order = sdk2.parameters.String('YT partner_to_order path', required=True)
            yt_service_complaints = sdk2.parameters.String('YT service_complaints path', required=True)
            yt_service_incidents = sdk2.parameters.String('YT service_incidents path', required=True)

        minimum_good_rating = sdk2.parameters.Integer('Minimum good rating', default=5)
        seconds_number_for_waiting = sdk2.parameters.Integer('Seconds number for waiting', default=86400)

        robot_login = sdk2.parameters.String('Robot login', default='robot-services')
        tvm_id = sdk2.parameters.Integer('TVM id', required=True)
        ydo_intapi_host = sdk2.parameters.String('ydo intapi host', required=True)

        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_process_suspended_order_partners_path,
            '--kikimr-host', self.Parameters.ydb_host,
            '--kikimr-home', self.Parameters.ydb_home,
            '--kikimr-database', self.Parameters.ydb_database,
            '--kikimr-port', str(self.Parameters.ydb_port),

            '--orders', self.Parameters.yt_orders,
            '--orders_aux', self.Parameters.yt_orders_aux,
            '--order_partner', self.Parameters.yt_order_partner,
            '--partner_to_order', self.Parameters.yt_partner_to_order,
            '--service_complaints', self.Parameters.yt_service_complaints,
            '--service_incidents', self.Parameters.yt_service_incidents,
        ]

        self.add_param_to_cmd(cmd, '--minimum_good_rating', str(self.Parameters.minimum_good_rating))
        self.add_param_to_cmd(cmd, '--seconds_number_for_waiting', str(self.Parameters.seconds_number_for_waiting))

        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))

        self.add_param_to_cmd(cmd, '--robot_login', str(self.Parameters.robot_login))
        self.add_param_to_cmd(cmd, '--tvm-id', str(self.Parameters.tvm_id))
        self.add_param_to_cmd(cmd, '--ydo-intapi-host', str(self.Parameters.ydo_intapi_host))

        execute_cmd(cmd, 'ydo_process_suspended_order_partners', 'ydo_process_suspended_order_partners failed', env=self.Parameters.get_environ())

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(YdoProcessSuspendedOrderPartners, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(YdoProcessSuspendedOrderPartners, self).on_finish(*args, **kwargs)
