# coding: utf-8
import logging

import sandbox.sdk2 as sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.common import task_env
from sandbox.projects.ydo import ydo_releasers
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view


logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)


class YdoPropagatePassportPolicyExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoPropagatePassportPolicy(sdk2.Task):
    """
        Распространение паспортной политики от категорий к партнёрам СМ
    """

    class Requirements(task_env.TinyRequirements):
        ram = 1024
        environments = [
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        ]

    class Parameters(generate_view(ydo_propagate_passport_policy=YdoPropagatePassportPolicyExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            order_partners_table = sdk2.parameters.String('Path to order partners backup', required=True)
            order_partners_by_spec_table = sdk2.parameters.String('Path to order partners by spec backup', required=True)
            categories_table = sdk2.parameters.String('Path to categories backup', required=True)

        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_propagate_passport_policy_path,
            '--kikimr-host', self.Parameters.ydb_host,
            '--kikimr-home', self.Parameters.ydb_home,
            '--kikimr-database', self.Parameters.ydb_database,
            '--kikimr-port', str(self.Parameters.ydb_port),
        ]
        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        self.add_param_to_cmd(cmd, '--kikimr-retry-count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr-delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr-backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr-limit', str(self.Parameters.ydb_limit))

        cmd.extend([
            '--action', 'set',
            'full_propagate',

            '--order_partners_backup', self.Parameters.order_partners_table,
            '--order_partner_by_spec_backup', self.Parameters.order_partners_by_spec_table,
            '--categories_backup', self.Parameters.categories_table,
        ])

        execute_cmd(cmd, 'ydo_propagate_passport_policy', 'ydo_propagate_passport_policy failed', env=self.Parameters.get_environ())
