from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoTranscribeCustomerCallRecordsExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoTranscribeCustomerCallRecords(sdk2.Task, SolomonMixinV2):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(ydo_transcribe_customer_call_records=YdoTranscribeCustomerCallRecordsExecutable, check_owner=True, with_environ=True)):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)

            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)

        with sdk2.parameters.Group('YT_TABLES'):
            yt_order_events = sdk2.parameters.String('Path to order_events_history backup', required=True)

        with sdk2.parameters.Group('CLOUD'):
            s3_cloud_bucket = sdk2.parameters.String('s3 cloud bucket', default='ydo-phone-records-for-stt')
            s3_cloud_url = sdk2.parameters.String('s3 cloud URL', default='https://storage.yandexcloud.net')
            cloud_request_timeout = sdk2.parameters.Float('Cloud request timeout', default=5.)
            enable_cloud_debug = sdk2.parameters.Bool('Enable cloud debug', default=False)

        with sdk2.parameters.Group('PHONE_RECORDS_S3'):
            phone_records_s3_access_key = sdk2.parameters.String('Phone records s3 access key', required=True)
            phone_records_s3_bucket = sdk2.parameters.String('Phone records s3 bucket', default='ydo-phone-records')

        session_retry_count = sdk2.parameters.Integer('Session retry count', default=10)
        threads_num = sdk2.parameters.Integer('Threads number', default=32)
        sleep_duration = sdk2.parameters.Float('Sleep duration (while waiting transcription)', default=10.)
        records_number_threshold = sdk2.parameters.Integer('Records number threshold', default=192)

        logging_config = sdk2.parameters.String('LoggingConfig', required=False)

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_transcribe_customer_call_records_path,
            '--kikimr_host', self.Parameters.ydb_host,
            '--kikimr_home', self.Parameters.ydb_home,
            '--kikimr_database', self.Parameters.ydb_database,
            '--kikimr_port', str(self.Parameters.ydb_port),
            '--kikimr_retry_count', str(self.Parameters.ydb_retry_count),
            '--kikimr_delay', str(self.Parameters.ydb_delay),
            '--kikimr_backoff', str(self.Parameters.ydb_backoff),
            '--kikimr_limit', str(self.Parameters.ydb_limit),

            '--order_events', self.Parameters.yt_order_events,

            '--s3_cloud_bucket', self.Parameters.s3_cloud_bucket,
            '--s3_cloud_url', self.Parameters.s3_cloud_url,
            '--cloud_request_timeout', str(self.Parameters.cloud_request_timeout),

            '--phone_records_s3_access_key', self.Parameters.phone_records_s3_access_key,
            '--phone_records_s3_bucket', self.Parameters.phone_records_s3_bucket,

            '--session_retry_count', str(self.Parameters.session_retry_count),
            '--threads_num', str(self.Parameters.threads_num),
            '--sleep_duration', str(self.Parameters.sleep_duration),
            '--records_number_threshold', str(self.Parameters.records_number_threshold),
        ]

        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)

        if self.Parameters.enable_cloud_debug:
            cmd.append('--enable_cloud_debug')

        execute_cmd(cmd, 'ydo_transcribe_customer_call_records', 'ydo_transcribe_customer_call_records failed', env=self.Parameters.get_environ())

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(YdoTranscribeCustomerCallRecords, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(YdoTranscribeCustomerCallRecords, self).on_finish(*args, **kwargs)
