use hahn;

$DELAY_THRESHOLD = 60;
$GOOD_LENGTH_THRESHOLD = 30;

insert into `//home/geo-search/alextim27/uslugi/production/proxy_phones/source_logs/new_history`
with truncate
select
    DateTime::ToSeconds(DateTime::MakeTimestamp(DateTime::ParseIso8601(A_DT_BEGIN)) + DateTime::IntervalFromHours(4)) as `timestamp`,
    cast(CONV_DUR as int64) as `length`,
    "+7" || A_BNUMBER as proxy_phone,
    "+7" || A_ANUMBER as client_phone,
    String::SplitToList(A_DT_BEGIN, " ")[0] as `date`
from
    range(`//home/ydo/proxy_phones/statements/1d`)
;
commit;

$date = "%GLOBAL_DATE%";
$not_working = "//home/geo-search/alextim27/uslugi/production/proxy_phones/probably_not_working/" || $date;
$result_log_table = "//home/geo-search/alextim27/uslugi/production/logs/proxy_phones/" || $date;

PRAGMA yt.InferSchema = '1';


$click_pool = (select * from range(`//home/geo-search/alextim27/uslugi/production/logs/click_pool`));
$proxy_source_log = (select * from concat(`//home/geo-search/alextim27/uslugi/production/proxy_phones/source_logs/new_history`, `//home/geo-search/alextim27/uslugi/production/proxy_phones/source_logs/history`));

$map = "//home/geo-search/alextim27/uslugi/production/proxy_phones/map";

$working_proxies = (
    select
        map.worker_id as worker_id,
        map.proxy_phone as proxy_phone,
        map.updated as updated,
        map.status as status
    from (
        select
            proxy_phone
        from
            $proxy_source_log
        group by proxy_phone
        having
            count(*) != count_if(`length` == 0)
            or count(*) < 5
    ) as w
    join $map as map
    on w.proxy_phone == map.proxy_phone
);


insert into $not_working
with truncate
select
    map.worker_id as worker_id,
    map.proxy_phone as proxy_phone,
    map.updated as updated,
    map.status as status
from (
    select
        proxy_phone
    from
        $proxy_source_log
    group by proxy_phone
    having
        count(*) == count_if(`length` == 0)
        and count(*) >= 5
) as w
join $map as map
on w.proxy_phone == map.proxy_phone;

$click_pool_with_proxy = (
    select
        click_pool.worker_id as worker_id,
        click_pool.reqid as reqid,
        click_pool.pos as pos,
        click_pool.path as path,
        DateTime::ToSeconds(DateTime::MakeTimestamp(DateTime::ParseIso8601(click_pool.EventTime))) as `timestamp`,
        click_pool.EventDate as `date`,
        click_pool.puid as puid,
        click_pool.yandexuid as yandexuid,
        if(map.updated < click_pool.EventDate, map.proxy_phone, null) ?? "no_proxy_phone" as proxy_phone
    from
        $click_pool as click_pool
    left join
        $working_proxies as map
    on click_pool.worker_id == map.worker_id
    where
        click_pool.path == "/SHOW_PHONE"
);


$joined_call = ($ts1, $ts2) -> {return Math::Abs($ts1 - $ts2) < $DELAY_THRESHOLD};


insert into $result_log_table
with truncate
select
    worker_id, reqid, pos, path, `timestamp`, `date`, puid, yandexuid, proxy_phone,
    if(max(`length`) == -1, null, max(`length`)) as `length`
from (
    select
        cpwp.worker_id as worker_id,
        cpwp.reqid as reqid,
        cpwp.pos as pos,
        cpwp.path as path,
        cpwp.`timestamp` as `timestamp`,
        cpwp.`date` as `date`,
        cpwp.puid as puid,
        cpwp.yandexuid as yandexuid,
        cpwp.proxy_phone as proxy_phone,
        if($joined_call(cast(cpwp.`timestamp` as int64), psl.`timestamp`), psl.`length`, -1) as `length`
    from
        $click_pool_with_proxy as cpwp
    left join
        $proxy_source_log as psl
    on cpwp.proxy_phone == psl.proxy_phone
) group by worker_id, reqid, pos, path, `timestamp`, `date`, puid, yandexuid, proxy_phone;

commit;

upsert into stat.`Maps_Plus_Beta/YDO/ProxyPhones/Main/daily`
select
    fielddate,
    (count_if(proxy_phone != "no_proxy_phone") / count_if(proxy_phone != "no_proxy_phone" and `length` is not null)) ?? 0 as coef_to_check,
    count(*) ?? 0 as connects,
    (count_if(proxy_phone != "no_proxy_phone")) ?? 0 as connects_with_proxy,
    count_if(proxy_phone != "no_proxy_phone" and `length` is not null) ?? 0 as joined,
    count_if(proxy_phone != "no_proxy_phone" and `length` is not null and `length` > $GOOD_LENGTH_THRESHOLD) ?? 0 as joined_long,
    ((count_if(proxy_phone != "no_proxy_phone" and `length` is not null and `length` > $GOOD_LENGTH_THRESHOLD) * 1.0) * (count(*) * 1.0 / count_if(proxy_phone != "no_proxy_phone"))) ?? 0 as approx_good_phone_connects,
    ((count_if(proxy_phone != "no_proxy_phone" and `length` is not null) * 1.0) * (count(*) * 1.0 / count_if(proxy_phone != "no_proxy_phone"))) ?? 0 as approx_all_phone_connects
from $result_log_table
group by `date` ?? $date as fielddate
having count_if(proxy_phone != "no_proxy_phone" and `length` is not null) != 0
