# coding=utf-8

from sandbox import sdk2

from sandbox.projects.ydo import ydo_releasers
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view, with_config


class YdoRemindersConfigUpdaterExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoRemindersConfigUpdater(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(with_config(
        generate_view(
            ydo_reminder_config_updater=YdoRemindersConfigUpdaterExecutable,
            check_owner=True,
            with_environ=True,
            default_secret_env_vars={
                'YDB_TOKEN': 'ydb-token',
            },
        ),
        configs_folder='ydo/tools/util/reminder_config_editor/lib',
        configs_choices=[
            ('testing', 'data_testing.json', ),
            ('production', 'data_production.json', ),
        ],
    )):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_reminder_config_updater_path,
            '--kikimr_host', self.Parameters.ydb_host,
            '--kikimr_home', self.Parameters.ydb_home,
            '--kikimr_database', self.Parameters.ydb_database,
            '--kikimr_port', str(self.Parameters.ydb_port),
            '--data_source', self.Parameters.config_path,
            '--confirm'
        ]

        execute_cmd(
            cmd,
            'ydo_reminder_config_updater',
            'ydo_reminder_config_updater failed',
            env=self.Parameters.get_environ()
        )
