import datetime

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view, with_config


class YdoRemindersGeneratorExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoRemindersGenerator(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        with_config(
            generate_view(
                ydo_reminders_generator=YdoRemindersGeneratorExecutable, check_owner=True, with_environ=True,
            ),
            'ydo/tools/reminders/reminders_generator/bin',
            [
                ('default', 'config.yaml'),
            ]
        )
    ):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_home = sdk2.parameters.String('Home', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)
            ydb_retry_count = sdk2.parameters.Integer('RetryCount', default=5)
            ydb_delay = sdk2.parameters.Integer('Delay', default=4)
            ydb_backoff = sdk2.parameters.Integer('Backoff', default=2)
            ydb_limit = sdk2.parameters.Integer('Limit', default=15)
        with sdk2.parameters.Group('YT_TABLES'):
            yt_repeated_orders = sdk2.parameters.String('YT repeated orders path', required=True)
            yt_completed_orders = sdk2.parameters.String('YT completed orders path', required=True)
        with sdk2.parameters.Group('REMINDERS'):
            reminder_type_repeated_orders = sdk2.parameters.String('Repeated orders reminder type id', required=True)
            reminder_type_completed_orders = sdk2.parameters.String('Completed orders reminder type id', required=True)
        with sdk2.parameters.Group('EXP_FLAGS'):
            exp_flags_host = sdk2.parameters.String('Host')
            exp_flags_service = sdk2.parameters.String('Service')
            exp_flags_context = sdk2.parameters.String('Context')
            exp_flags_timeout = sdk2.parameters.Integer('Timeout')
            exp_flags_connection_timeout = sdk2.parameters.Integer('ConnectionTimeout')

        logging_config = sdk2.parameters.String('LoggingConfig')

    def add_param_to_cmd(self, cmd, name, parameter):
        if parameter:
            cmd += [name, parameter]

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_reminders_generator_path,
            '--config', self.Parameters.config_path,
            '--kikimr_host', self.Parameters.ydb_host,
            '--kikimr_home', self.Parameters.ydb_home,
            '--kikimr_database', self.Parameters.ydb_database,
            '--kikimr_port', str(self.Parameters.ydb_port),

            '--repeated_orders', self.Parameters.yt_repeated_orders,
            '--completed_orders', self.Parameters.yt_completed_orders,
            '--repeat_order_reminder_type_id', self.Parameters.reminder_type_repeated_orders,
            '--completed_order_reminder_type_id', self.Parameters.reminder_type_completed_orders,
        ]

        self.add_param_to_cmd(cmd, '--logging-config', self.Parameters.logging_config)
        self.add_param_to_cmd(cmd, '--kikimr_retry_count', str(self.Parameters.ydb_retry_count))
        self.add_param_to_cmd(cmd, '--kikimr_delay', str(self.Parameters.ydb_delay))
        self.add_param_to_cmd(cmd, '--kikimr_backoff', str(self.Parameters.ydb_backoff))
        self.add_param_to_cmd(cmd, '--kikimr_limit', str(self.Parameters.ydb_limit))
        self.add_param_to_cmd(cmd, '--exp_flags_host', str(self.Parameters.exp_flags_host))
        self.add_param_to_cmd(cmd, '--exp_flags_service', str(self.Parameters.exp_flags_service))
        self.add_param_to_cmd(cmd, '--exp_flags_context', str(self.Parameters.exp_flags_context))
        self.add_param_to_cmd(cmd, '--exp_flags_timeout', str(self.Parameters.exp_flags_timeout))
        self.add_param_to_cmd(cmd, '--exp_flags_connection_timeout', str(self.Parameters.exp_flags_connection_timeout))

        execute_cmd(cmd, 'ydo_reminders_generator', 'ydo_reminders_generator failed', env=self.Parameters.get_environ())
