# -*- coding: utf-8 -*-
import os

import datetime
import logging

import sandbox.sdk2 as sdk2
from sandbox.projects.ydo import get_last_released_resource, execute_cmd, wait_process, ydo_releasers
from sandbox.projects.ipreg import IPREG_EXPORT


class YdoParseLogsExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoParseLogsTask(sdk2.Task):
    """
        Парсинг reqanslog  SaaSa
    """

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        reqans_dir = sdk2.parameters.String(
            'SaaS-reqans-log directory',
            default_value='//logs/saas-reqans-log/1d'
        )

        output_dir = sdk2.parameters.String(
            'output directory',
            default_value='//home/ydo/logs/prod/reqans'
        )

        date_str_from = sdk2.parameters.String(
            'Date start (%Y-%m-%d)',
            default_value=(datetime.date.today() - datetime.timedelta(1)).isoformat()
        )
        date_str_to = sdk2.parameters.String(
            'Date finish (%Y-%m-%d)',
            default_value=(datetime.date.today() - datetime.timedelta(1)).isoformat()
        )

        reqans_service = sdk2.parameters.String('SaaS reqans-log service')
        reqans_other_params = sdk2.parameters.String('additional params')

    def on_execute(self):
        date_from = datetime.datetime.strptime(self.Parameters.date_str_from, '%Y-%m-%d').date()
        date_to = datetime.datetime.strptime(self.Parameters.date_str_to, '%Y-%m-%d').date()

        date_range = (date_to - date_from).days + 1

        env = os.environ.copy()
        env["YT_TOKEN"] = sdk2.Vault.data(self.owner, 'yt-token')

        logging.info('{} tables to parse'.format(str(date_range)))

        for day in range(date_range):
            date_to_process = (date_from + datetime.timedelta(day)).isoformat()

            cmd = [
                str(get_last_released_resource(YdoParseLogsExecutable, error_msg="YdoParseLogsExecutable not found").path),
                '--service', self.Parameters.reqans_service,
                '--reqans_table', '/'.join((self.Parameters.reqans_dir, date_to_process)),
                '--output_table', date_to_process,
                '--output_dir', '/'.join((self.Parameters.output_dir, self.Parameters.reqans_service)),
                '--ipreg', str(get_last_released_resource(IPREG_EXPORT, error_msg="IPREG_EXPORT not found").path)
            ] + self.Parameters.reqans_other_params.split()

            logging.info('Parse process for {} has been started'.format(date_to_process))
            parse_process = execute_cmd(cmd, "parse_reqans_log", env=env, should_wait=False)

            wait_process(parse_process, 'Parse process for {} failed'.format(date_to_process))
            logging.info('Process {} finished'.format(date_to_process))
