import sandbox.sdk2 as sdk2

ydo_releasers = [
    "robot-uslugi-analyst",
    "muzich",
    "niksorokin",
    "robot-geosearch",
    "sukhoi",
    "zhshishkin",
    "alextim27",
    "kate-zabelova",
    "gav1995",
    "diplay",
    "grand",
    "ap-lunkin",
    "maxim98",
    "mesherin",
    "osfavstov",
    "bokoveg",
    "ilyaifanov",
    "aleksey-titov",
    "antonzakharov",
    "pazdnikov",
    "agul",
    "robot-services",
    "woolly",
    "ayashin87",
    "sunflower",
    "dezzan",
    "kozlinskii",
    "vladmiron",
    "ladunoff",
    "werelaxe",
    "polevgart",
    "phil-nox",
    "eevee",
    "shendas",
    "dimarub2000",
    "yel1ow",
    "saylars",
    "grigorev-grig",
    "aabolotin",
    "esenenkova",
    "danwallgun",
    "dpleshcheev",
    "idgrigorev",
    "torchrik",
    "vapavlov",
    "anatoly32322",
    "barukhov",
    "rauan-omarov",
    "vgrishanin",
    "arkady-b",
    "prog-metal",
    "zaber",
    "sychusha",
    "waaagh",
    "danya090699",
    "handzo",
    "eiztna",
]

rm_releasers = [
    "robot-testenv",
    "robot-srch-releaser",
]

frontend_releasers = [
    "xplk",
    "i-zuev",
    "alexdivin",
    "nyakto",
    "asterx",
    "robot-frontend",
    "robot-serp-bot",
]

content_releasers = ydo_releasers + [
    "andreigalai",
    "msbykova",
    "nastkozlova",
    "panfil",
    "poluektova-ai",
    "valeriakurn",
    "vasilymakeev",
    "antalovc",
    "YDO",
    "kabardinovd",
    "nobelou",
]


class YdoBackendRequestExtractor(sdk2.Resource):
    """
    Resource YDO_BACKEND_REQUEST_EXTRACTOR apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/extract_backend_request_source"


class YdoRequestExtractor(sdk2.Resource):
    """
    Resource YDO_REQUEST_EXTRACTOR apphost source binary
    Need for release_machine
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/extract_backend_request_source"


class YdoGolovanAlerts(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/devops/monitorings/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="ydo_monitoring_alerts")


class YdoAlertsV2Creator(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/devops/monitorings/alerts_v2/bin/creator"
    executable = True


class YdoWord2VecBinModel(sdk2.Resource):
    """
    Resource YDO_WORD_2_VEC_BIN_MODEL
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDssmModel(sdk2.Resource):
    """
    Resource YDO_DSSM_MODEL
    DSSM
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoReformulationsDssmModel(sdk2.Resource):
    """
    Resource YDO_REFORMULATIONS_DSSM_MODEL
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoWorkerOrderMatchingDssmModel(sdk2.Resource):
    """
    Resource YDO_WORKER_ORDER_MATCHING_DSSM_MODEL
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoOrderReactionPredictionRankingDssmModel(sdk2.Resource):
    """
    Resource YDO_ORDER_REACTION_PREDICTION_RANKING_DSSM_MODEL
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSearchConnectionsRankingDssmModel(sdk2.Resource):
    """
    Resource YDO_SEARCH_CONNECTIONS_RANKING_DSSM_MODEL
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoBgTaskProcessor(sdk2.Resource):
    """
    background task processor
    take scheduled task from ydb queue and process it with handlers
    https://st.yandex-team.ru/YDO-5764
    """

    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/bg_task_processor/bin"
    binary_path = sdk2.parameters.String(default="bg_task_processor")


class YdoAnnSessionsPreparer(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/indexann/create_annotations/prepare_sessions"
    executable = True


class YdoAnnStatCalculator(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/indexann/create_annotations/calculate_statistics"
    executable = True


class YdoImageUploader(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/image_uploader/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="image_uploader")


class YdoBackend(sdk2.Resource):
    """
    Resource YDO_BACKEND apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/apphost_source/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="apphost_source")


class YdoAsyncApiWorker(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/worker"
    executable = True


class YdoAsyncApiWorkerConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/worker/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoAsyncApiSupervisor(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/supervisor"
    executable = True

    binary_path = sdk2.parameters.String(default="ydo_supervisor")


class YdoAsyncApiSupervisorConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/supervisor/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoSearchAsyncApiSupervisorConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/supervisor/rt_worker_indexer_configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoReplicationAsyncApiSupervisorConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/supervisor/replication_configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoAsyncApiInfraConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/config_infra"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoSearchAsyncApiWorkerConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/worker/rt_worker_indexer_configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoReplicationAsyncApiWorkerConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/async_api/bin/worker/replication_configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoGetResponsesDecoder(sdk2.Resource):
    """
    Resource YDO_GET_RESPONSES_DECODER binary
    """

    any_arch = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "junk/gav1995/ReleaseMachine/proto_decoder"


class YdoLogbrokerDelivery(sdk2.Resource):
    """
    Resource YDO_LOGBROKER_DELIVERY binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/logbroker_delivery/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="logbroker_delivery")


class YdoEmbeddingServer(sdk2.Resource):
    """
    YDO_EMBEDDING_SERVER binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/embedding_server"
    executable = True

    binary_path = sdk2.parameters.String(default="embedding_server")


class YdoGolovanMenu(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/devops/monitorings/golovan_menu"
    executable = True

    binary_path = sdk2.parameters.String(default="ydo_golovan_menu")


class YdoSolo(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/devops/monitorings/solo/creator"
    executable = True


class YdoErrorboosterAlerts(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/devops/monitorings/errorbooster/bin"
    binary_path = sdk2.parameters.String(default="ydo_errorbooster_alerts")
    executable = True


class YdoYtMonthlyMergerExecutable(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/devops/yt_tools/yt_table_monthly_merger/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="yt_monthly_merger")


class YdoNotificationsFrontend(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers + frontend_releasers


class YdoNotificationsBackend(sdk2.Resource):
    """
    YDO_NOTIFICATIONS_BACKEND binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/notifications/server/bin/backend"
    executable = True
    binary_path = sdk2.parameters.String(default="notifications_backend")


class YdoPruningModel(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoLandingTexts(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoVerifiedRatingConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoServiceEmbeddings(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoServiceMatcher(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoEmbeddingServerDssmModel(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoPopularQueriesGzt(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoStopWordsGzt(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoBrandsGzt(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoFormAnswersGzt(sdk2.Resource):
    releasable = True
    releasers = content_releasers


class YdoFormAnswersGztCompilerExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoFormAnswersSynonymsGzt(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoOrderCustomizerSeoDataJson(sdk2.Resource):
    releasable = True
    releasers = content_releasers


class YdoUniversalNotifierExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/notifiers/universal_notifier/bin"
    binary_path = sdk2.parameters.String(default="universal_notifier")


class YdoERPBackend(sdk2.Resource):
    """
    Resource YDO_ERP_BACKEND apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/erp/server/bin/backend"
    executable = True

    binary_path = sdk2.parameters.String(default="erp")


class YdoCppERPBackend(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/erp/cpp/server/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="cerp")


class YdoERPBackendConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/erp/server/bin/backend/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoCppERPBackendConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/erp/cpp/server/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoERPBackendInfraConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/erp/server/bin/config_infra"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoERPBackendOrderStateGraphs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/erp/server/bin/backend/order_state_graphs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoERPBackendRegionPresets(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/erp/server/bin/backend/region_presets"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoDispatch(sdk2.Resource):
    """
    Resource YDO_DISPATCH apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/dispatch/server/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="ydo_dispatch")


class YdoDispatchDistanceGrid(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchDensityGrid(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchTags(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchBlackWhiteListProduction(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchBlackWhiteListTesting(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchLightPartnerConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchLightPartnerConfigTesting(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchTesterModel(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchTesterWorkersGeopoints(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchTesterDataset(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchTesterBinary(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/dispatch/dispatch_tester"
    executable = True

    binary_path = sdk2.parameters.String(default="dispatch_tester")


class YdoDispatchAnalyzeMetricsBinary(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/dispatch/analyze_metrics"
    executable = True

    binary_path = sdk2.parameters.String(default="analyze_metrics")


class YdoRedispatcherExactConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSendToSaasLbExecutable(sdk2.Resource):
    """
    Send table with proto documents to SAAS Logbroker
    """

    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoSrcSetupConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoSrcSetupInstanceCtlConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoServiceModelCategoriesJson(sdk2.Resource):
    """
    Json with rubric_id to geoids
    """

    releasable = True
    releasers = ydo_releasers


class YdoMonitoringServiceModelCategoriesJson(sdk2.Resource):
    """
    Json with rubric_id to geoids
    Enable monitorings for experimental categories which not rolled out to 100%
    """

    releasable = True
    releasers = ydo_releasers


class YdoDevopsDaemonReloader(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/devops/daemons/reloader"
    executable = True


class YdoBackendRenderer(sdk2.Resource):
    """
    Resource YDO_BACKEND_RENDERER apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/renderer/bin/backend"
    executable = True

    binary_path = sdk2.parameters.String(default="renderer")


class YdoBackendRendererConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/renderer/bin/backend/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoBackendRendererInfraConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/server/renderer/bin/config_infra"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoDispatchShooterExecutable(sdk2.Resource):
    """
    Resource YDO_DISPATCH_SHOOTER apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/shooter/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="dispatch_shooter")


class YdoDispatchShooterConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/shooter/bin/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoRedispatcherExecutable(sdk2.Resource):
    """
    Resource YDO_REDISPATCHER apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/redispatcher/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="redispatcher")


class YdoRedispatcherMonitoringExecutable(sdk2.Resource):
    """
    Resource YDO_REDISPATCHER apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/redispatcher_monitoring"
    executable = True

    binary_path = sdk2.parameters.String(default="redispatcher_monitoring")


class YdoOrdersPredictionExecutable(sdk2.Resource):
    """
    Resource YDO_ORDERS_PREDICTOR source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/orders_prediction"
    executable = True

    binary_path = sdk2.parameters.String(default="orders_prediction")


class YdoRedispatcherConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/redispatcher/bin/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoDispatchMapsExecutable(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/dispatch_maps"
    executable = True

    binary_path = sdk2.parameters.String(default="dispatch_maps")


class YdoDispatchMapsDirectory(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoCacheShooterExecutable(sdk2.Resource):
    """
    Resource YDO_CACHE_SHOOTER apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/cache_shooter"
    executable = True

    binary_path = sdk2.parameters.String(default="cache_shooter")


class YdoCacheShooterConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/cache_shooter/config"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoTestMarketExecutable(sdk2.Resource):
    """
    Resource YDO_TEST_MARKET_EXECUTABLE source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/market/test_market/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="test_market")


class YdoDispatchCacheIndexerExecutable(sdk2.Resource):
    """
    Resource YDO_DISPATCH_CACHE_INDEXER apphost source binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/cache_indexer/bin"
    executable = True

    binary_path = sdk2.parameters.String(default="cache_indexer")


class YdoDispatchCacheIndexerConfigs(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/cache_indexer/bin/configs"

    not_single_file = sdk2.parameters.Bool(default=True)


class YdoDispatchCacheReferencePoints(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoDispatchCachePartnerFlowServices(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoDispatchHomeGeopoints(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchCacheDefaultPartner(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoDispatchPolygonsJson(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoDispatchClustersJson(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoCancelReasonsConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoReworkReasonsConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoDispatchPolygonRestrictionsJson(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoDispatchPolygonRestrictionsJsonTesting(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoDispatchPartnerRentConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers


class YdoOrderProblemsConfig(sdk2.Resource):
    releasable = True
    releasers = content_releasers


class YdoDispatchOrderLossMapExecutable(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/dispatch/order_loss_map"
    executable = True

    binary_path = sdk2.parameters.String(default="order_loss_map")


class YdoDispatchOrderLossMapDirectory(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoCustomerFakePhonesConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoOutOfCityMainConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoOutOfCityKadConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoOutOfCityPolygonConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoArbitragePenaltyConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoArbitrageTagsConfig(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoGenerateServiceModelSitemapExecutable(sdk2.Resource):
    """
    Service model sitemap generator executable
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers
    arcadia_build_path = "ydo/tools/search_index/service_model_sitemap_generator"
    executable = True

    binary_path = sdk2.parameters.String(default="service_model_sitemap_generator")


class YdoPromocodeSettings(sdk2.Resource):
    """
    promocode settings: promocode types, default promocodes, etc
    """

    releasable = True
    releasers = ydo_releasers


class YdoSlicesConfig(sdk2.Resource):
    """
    slices config for order slice lib
    """

    releasable = True
    releasers = ydo_releasers


class YdoDispatchRankingModel(sdk2.Resource):
    """
    One catboost dispatch ranking model
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchRankingBundle(sdk2.Resource):
    """
    Several dispatch ranking models (for multiple specs)
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchTesterResult(sdk2.Resource):
    """
    Resource with dispatch tester metrics
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoDispatchTesterResultDiff(sdk2.Resource):
    """
    Resource with dispatch tester metrics diff for quality acceptance
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoMarketingAudienceBidsModel(sdk2.Resource):
    """
    Model for audience bids modifiers in marketing
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers


class YdoRedispatcherTransitionMap(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers
    organization_id = sdk2.resource.Attributes.String("organization_id")
    date = sdk2.resource.Attributes.String("date")


class YdoResponseTimingsToSolomon(sdk2.Resource):
    """
    Resource YDO_RESPONSE_TIMINGS_TO_SOLOMON binary
    """

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers + rm_releasers

    executable = True
    arcadia_build_path = "ydo/tools/response_timings_to_solomon/bin"
    binary_path = sdk2.parameters.String(default="response_timings_to_solomon")


class YdoDispatchGeotrackingBinary(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/dispatch/analyze_geo_tracking"
    executable = True

    binary_path = sdk2.parameters.String(default="analyze_geo_tracking")


class YdoDispatchGeotrackingDirectory(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoRunningOrderTestIds(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers
