from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
from sandbox.projects.ydo import (
    execute_cmd,
    ydo_releasers,
    YdoRubricatorVersion,
)

from sandbox.projects.ydo.self_release.ReleaseParentTask import (
    SelfReleaseOnSuccessMixin,
    SelfReleaseOnSuccessMixinParameters
)

from sandbox.projects.ydo.parameters_view import generate_view, with_config


class YdoRubricsVersionsCalcerExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoRubricsVersionsCalcer(nanny.ReleaseToNannyTask2, sdk2.Task, SelfReleaseOnSuccessMixin):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        with_config(
            generate_view(
                executable=YdoRubricsVersionsCalcerExecutable,
                with_environ=True,
                check_owner=True,
                default_secret_env_vars={
                    'SOLOMON_TOKEN': 'solomon-token'
                }
            ),
            'ydo/tools/rubricator/calc_rubrics_versions',
            [
                ('default', 'services_path.json'),
                ('testing', 'services_path_testing.json')
            ]
        )
    ):
        self_release_parameters = SelfReleaseOnSuccessMixinParameters()
        solomon_project = sdk2.parameters.String('Solomon project', default='ydo')
        solomon_cluster = sdk2.parameters.String('Solomon cluster', default='sandbox_tasks')
        solomon_service = sdk2.parameters.String('Solomon service', default='rubricator_version')
        solomon_type = sdk2.parameters.String('Solomon type')

    def on_execute(self):
        resource = YdoRubricatorVersion(self, 'Actual rubricator version', 'rubricator_version')
        resource_data = sdk2.ResourceData(resource)

        env = self.Parameters.get_environ()
        cmd = [
            self.Parameters.executable_path,
            '--solomon_project', self.Parameters.solomon_project,
            '--solomon_cluster', self.Parameters.solomon_cluster,
            '--solomon_service', self.Parameters.solomon_service,
            '--solomon_type', self.Parameters.solomon_type,
            '--services_path', self.Parameters.config_path,
            '--resource_path', str(resource_data.path)
        ]

        execute_cmd(cmd, 'executable', 'Failed', env=env)
        resource_data.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)

    def on_success(self, prev_status):
        SelfReleaseOnSuccessMixin.on_success(self, prev_status)
        sdk2.Task.on_success(self, prev_status)
