from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
from sandbox.projects.ydo import (
    execute_cmd,
    ydo_releasers,
    YdoRubricsDump,
    YdoSpravRubricsDump,
    YdoGeo2WorkersCountDump,
    YdoSpravGeo2WorkersCountDump,
)


class YdoRubricsMergerExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoMergedRubricsDump(sdk2.Resource):
    """
        Json with rubrics from all sources
    """
    releasable = True
    releasers = ydo_releasers


class YdoMergedRubricsSmallDump(sdk2.Resource):
    """
        Json with rubrics from all sources
    """
    releasable = True
    releasers = ydo_releasers


class YdoMergedGeo2WorkersCountDump(sdk2.Resource):
    """
        Json with geoid to workers number from all sources
    """
    releasable = True
    releasers = ydo_releasers


class YdoRubricsMerger(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        rubrics_merger_executable_resource = sdk2.parameters.Resource(
            "rubrics_merger",
            resource_type=YdoRubricsMergerExecutable,
            required=True,
        )
        rubrics_dump = sdk2.parameters.Resource(
            "rubrics_dump",
            resource_type=YdoRubricsDump,
            required=True,
        )
        sprav_rubrics_dump = sdk2.parameters.Resource(
            "sprav_rubrics_dump",
            resource_type=YdoSpravRubricsDump,
            required=True,
        )
        geoid2workers_count = sdk2.parameters.Resource(
            "geoid2workers_count",
            resource_type=YdoGeo2WorkersCountDump,
            required=True,
        )
        sprav_geoid2workers_count = sdk2.parameters.Resource(
            "sprav_geoid2workers_count",
            resource_type=YdoSpravGeo2WorkersCountDump,
            required=True,
        )

    def on_execute(self):
        cmd = [
            str(sdk2.ResourceData(self.Parameters.rubrics_merger_executable_resource).path),
            '--out', 'rubrics.json',
            '--out_small', 'rubrics_small.json',
            '--out_geoid2workers_count', 'geoid2workers_count.json',
        ]
        for name in ("rubrics_dump", "sprav_rubrics_dump", "geoid2workers_count", "sprav_geoid2workers_count"):
            resource = getattr(self.Parameters, name)
            if resource is not None:
                cmd += [
                    "--" + name,
                    str(sdk2.ResourceData(resource).path),
                ]

        rubrics_resource = sdk2.ResourceData(YdoMergedRubricsDump(self, 'Ydo rubrics dump from all sources', 'rubrics.json'))
        rubrics_small_resource = sdk2.ResourceData(YdoMergedRubricsSmallDump(self, 'Ydo rubrics dump without geoid2workers_count maps from all sources', 'rubrics_small.json'))
        geoid2workers_count = sdk2.ResourceData(YdoMergedGeo2WorkersCountDump(self, 'All workers count in any rubric in geoid from all sources', 'geoid2workers_count.json'))

        execute_cmd(cmd, "rubrics_merger", "rubrics_merger failed")
        rubrics_resource.ready()
        rubrics_small_resource.ready()
        geoid2workers_count.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
