from sandbox import sdk2
from sandbox.projects.ydo import (
    ydo_releasers,
    execute_cmd,
)
from sandbox.projects.ydo.parameters_view import generate_view


class YdoSearchIndexGrantTrialBoostExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoSearchIndexGrantTrialBoost(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(
        grant_trial_boost=YdoSearchIndexGrantTrialBoostExecutable,
        check_owner=True,
        with_environ=True,
        default_env_vars={
            'YT_PROXY': 'hahn.yt.yandex.net',
        },
        default_secret_env_vars={
            'YT_TOKEN': 'yt-token',
            'SOLOMON_TOKEN': 'solomon-token',
        }
    )):
        output_table = sdk2.parameters.String('Output table', required=True)
        last_time_promotion_activity = sdk2.parameters.Integer('Promotion active period', required=False, default=2)
        calls_count = sdk2.parameters.Integer('Workers calls count', required=False, default=3)
        calls_history_path = sdk2.parameters.String('Calls version history output table', required=False, default='//home/ydo/direct_promotion/boost_workers/granted_calls')
        calls_for_days = sdk2.parameters.Integer('Calls for days', required=False, default=3)
        min_call_length = sdk2.parameters.Integer('Minimum call length', required=False, default=60)
        workers_table = sdk2.parameters.String('Workers active status history table', required=False, default='//home/ydo/backups_v2/links/last_prod/direct_info')
        calls_directory = sdk2.parameters.String('Calls directory', required=False, default='//home/ydo/proxy_phones/statements/telephony/production/1d')
        calc_date = sdk2.parameters.String('Date of last calls table', required=False, default='')

        sessions_table = sdk2.parameters.String('Table with sessions', required=False, default='//home/ydo/direct_promotion/sessions/promotion_intervals')
        test_share = sdk2.parameters.Integer('Percentage of workers in test', required=False, default=50)
        new_promoters_history_path = sdk2.parameters.String('New promoters version history output table', required=False, default='//home/ydo/direct_promotion/boost_workers/new_promoters_history')
        days_since_last_modification = sdk2.parameters.Integer('Max sessions table modification delay', required=False, default=3)
        sessions_length = sdk2.parameters.Integer('Max possible session length', required=False, default=7)

        grant_version = sdk2.parameters.String('Version of grant', required=False, choices=(('calls', 'calls'), ('new_promoters', 'new_promoters')), default='calls')

        enable_monitoring = sdk2.parameters.Bool('Enable solomon monitoring', required=True, default=False)
        solomon_project = sdk2.parameters.String('Solomon project', required=False, default='ydo')
        solomon_cluster = sdk2.parameters.String('Solomon cluster', required=False, default='direct')
        solomon_service = sdk2.parameters.String('Solomon service', required=False, default='grant_trial_boost')
        solomon_type = sdk2.parameters.String('Solomon type', required=False)
        cmd_params = sdk2.parameters.String('Additional cmd args')

    def on_execute(self):
        execute_cmd(
            [
                self.Parameters.grant_trial_boost_path,
                '--output_table', self.Parameters.output_table,
                '--last_time_promotion_activity', str(self.Parameters.last_time_promotion_activity),
                '--calls_count', str(self.Parameters.calls_count),
                '--calls_history_path', self.Parameters.calls_history_path,
                '--calls_for_days', str(self.Parameters.calls_for_days),
                '--min_call_length', str(self.Parameters.min_call_length),
                '--workers_table', self.Parameters.workers_table,
                '--calls_directory', self.Parameters.calls_directory,
                '--calc_date', self.Parameters.calc_date,

                '--sessions_table', self.Parameters.sessions_table,
                '--test_share', str(self.Parameters.test_share),
                '--new_promoters_history_path', self.Parameters.new_promoters_history_path,
                '--days_since_last_modification', str(self.Parameters.days_since_last_modification),
                '--sessions_length', str(self.Parameters.sessions_length),

                '--grant_version', self.Parameters.grant_version,
            ]
            + (
                [
                    '--enable_monitoring',
                    '--solomon_project', self.Parameters.solomon_project,
                    '--solomon_cluster', self.Parameters.solomon_cluster,
                    '--solomon_service', self.Parameters.solomon_service,
                    '--solomon_type', self.Parameters.solomon_type,
                ] if self.Parameters.enable_monitoring else []
            )
            + (
                self.Parameters.cmd_params.split() if self.Parameters.cmd_params else []
            ),
            'ydo_search_index_grant_trial_boost',
            'Failed to create grant trial boost table',
            env=self.Parameters.get_environ()
        )
