from sandbox import sdk2
import sandbox.common.types.task as ctt


class SelfReleaseOnSuccessMixinParameters(sdk2.Parameters):
    with sdk2.parameters.RadioGroup('Release created resources to') as release_type:
        for value in list(ctt.ReleaseStatus):
            release_type.values[value] = release_type.Value(value)


class SelfReleaseOnSuccessMixin(object):
    class Parameters(SelfReleaseOnSuccessMixinParameters):
        pass
    def on_success(self, prev_status):
        if self.Parameters.release_type:
            YdoReleaseTask(
                self,
                release_type=self.Parameters.release_type,
                task_to_release=sdk2.Task[self.id],
            ).enqueue()


class YdoReleaseTask(sdk2.Task):
    class Parameters(sdk2.Parameters):
        release_type = sdk2.parameters.String('Release type')
        task_to_release = sdk2.parameters.Task("Task to release")

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        with self.memoize_stage.wait_for_parent:
            raise sdk2.WaitTask(
                tasks=[self.Parameters.task_to_release],
                statuses=(ctt.Status.Group.FINISH + ctt.Status.Group.BREAK),
                wait_all=True
            )

        if self.Parameters.task_to_release.status == ctt.Status.SUCCESS:
            self.server.release(
                task_id=int(self.Parameters.task_to_release),
                type=self.Parameters.release_type,
                subject='Automatic release of ' + self.Parameters.description
            )
