from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd

from sandbox.projects.ydo.default_multislot_task import YdoMutlihostTask
from sandbox.projects.ydo.parameters_view import generate_view


class YdoSendingCenterLogsExtractorExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSendingCenterLogsExtractorTask(YdoMutlihostTask):
    class Parameters(generate_view(log_extractor=YdoSendingCenterLogsExtractorExecutable, check_owner=True, with_environ=True)):
        cmd = sdk2.parameters.String(
            "Command line parameters",
            required=True,
        )

    def on_execute(self):
        cmd = [self.Parameters.log_extractor_path]
        cmd += self.Parameters.cmd.split()

        env = self.Parameters.get_environ()

        execute_cmd(cmd, "log_extractor", "log_extractor failed", env=env)
