import json

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.ydo.solomon_mixin import SolomonMixinV2


class YdoSyncErpStatusExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSyncErpStatus(sdk2.Task, SolomonMixinV2):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        generate_view(
            ydo_sync_erp_status=YdoSyncErpStatusExecutable,
            check_owner=True,
            with_environ=True,
        )
    ):
        with sdk2.parameters.Group('KIKIMR_CONNECTION'):
            ydb_host = sdk2.parameters.String('Host', required=True)
            ydb_backend_home = sdk2.parameters.String('Home for backend', required=True)
            ydb_erp_home = sdk2.parameters.String('Home for erp', required=True)
            ydb_database = sdk2.parameters.String('Database', required=True)
            ydb_port = sdk2.parameters.Integer('Port', default=2135)

    def on_execute(self):
        execute_cmd(
            [
                self.Parameters.ydo_sync_erp_status_path,
                '--ydb_host',
                self.Parameters.ydb_host,
                '--ydb_backend_home',
                self.Parameters.ydb_backend_home,
                '--ydb_erp_home',
                self.Parameters.ydb_erp_home,
                '--ydb_database',
                self.Parameters.ydb_database,
                '--ydb_port',
                str(self.Parameters.ydb_port),
            ],
            'ydo_sync_erp_status',
            'ydo_sync_erp_status failed',
            env=self.Parameters.get_environ(),
        )

    def on_break(self, *args, **kwargs):
        SolomonMixinV2.on_break(self, *args, **kwargs)
        super(YdoSyncErpStatus, self).on_break(*args, **kwargs)

    def on_finish(self, *args, **kwargs):
        SolomonMixinV2.on_finish(self, *args, **kwargs)
        super(YdoSyncErpStatus, self).on_finish(*args, **kwargs)
