import os

from sandbox import sdk2

from sandbox.projects.ydo import (
    ydo_releasers,
    execute_cmd,
)
from sandbox.projects.ydo.rubrics_merger.YdoRubricsMerger import YdoMergedRubricsDump


class YdoGenSuggestDictsExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoSuggestDicts(sdk2.Resource):
    """Data for ydo rubrics suggest"""
    releasable = True
    releasers = ydo_releasers
    suggest_handler = sdk2.Attributes.String("Name of the suggest handler to be released to")


class YdoProblemsDump(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoGenSuggestDicts(sdk2.Task):
    class Parameters(sdk2.Parameters):

        generator = sdk2.parameters.Resource(
            'generator executable',
            resource_type=YdoGenSuggestDictsExecutable,
            required=True
        )
        rubrics_dump = sdk2.parameters.Resource(
            "rubrics_dump",
            resource_type=YdoMergedRubricsDump,
            required=True,
        )
        problems_dump = sdk2.parameters.Resource(
            "problems_dump",
            resource_type=YdoProblemsDump,
            required=False
        )
        suggest_handler = sdk2.parameters.String('Name of the suggest handler to be released to')
        rubricator_version = sdk2.parameters.Integer('Version of YDO rubricator', default=1)

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def gen_dicts(self):
        resource = YdoSuggestDicts(self, "Suggest dicts", "suggest_dicts", suggest_handler=self.Parameters.suggest_handler)
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.mkdir(0o755, parents=True, exist_ok=True)

        yt_token = sdk2.Vault.data(self.owner, 'yt-token')

        env = os.environ.copy()
        env['YT_TOKEN'] = yt_token
        env['YT_PROXY'] = 'hahn.yt.yandex.net'
        env['YT_LOG_LEVEL'] = 'INFO'

        cmd_params = [
            str(sdk2.ResourceData(self.Parameters.generator).path),
            "--rubrics_json", str(sdk2.ResourceData(self.Parameters.rubrics_dump).path),
            "--out_dir", str(resource_data.path),
        ]
        if self.Parameters.rubricator_version:
            cmd_params += ["--rubricator_version", str(self.Parameters.rubricator_version)]
        if self.Parameters.problems_dump:
            path = str(sdk2.ResourceData(self.Parameters.problems_dump).path)
            cmd_params += ["--problems", path + "/problems", "--problems_groups", path + "/problems_groups"]
        execute_cmd(
            cmd_params,
            'gen_suggest_dicts',
            'Failed to create dicts',
            env=env
        )

        resource_data.ready()

    def on_execute(self):
        self.gen_dicts()
