from sandbox import sdk2

from sandbox.projects.ydo import (
    ydo_releasers,
    execute_cmd,
)


class YdoGenSuggestProblemsDictsExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoSuggestProblemsDicts(sdk2.Resource):
    """Data for ydo rubrics suggest"""
    releasable = True
    releasers = ydo_releasers
    suggest_handler = sdk2.Attributes.String("Name of the suggest handler to be released to")


class YdoProblemsData(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoGenSuggestProblemsDicts(sdk2.Task):
    class Parameters(sdk2.Parameters):

        generator = sdk2.parameters.Resource(
            'generator executable',
            resource_type=YdoGenSuggestProblemsDictsExecutable,
            required=True
        )
        problems_data = sdk2.parameters.Resource(
            "problems_data",
            resource_type=YdoProblemsData,
            required=True
        )
        suggest_handler = sdk2.parameters.String('Name of the suggest handler to be released to')

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def gen_dicts(self):
        resource = YdoSuggestProblemsDicts(self, "Suggest problems dicts", "suggest_problems_dicts", suggest_handler=self.Parameters.suggest_handler)
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.mkdir(0o755, parents=True, exist_ok=True)

        cmd_params = [
            str(sdk2.ResourceData(self.Parameters.generator).path),
            "--problems", str(sdk2.ResourceData(self.Parameters.problems_data).path) + "/data",
            "--problems_group", str(sdk2.ResourceData(self.Parameters.problems_data).path) + "/groupings",
            "--out_dir", str(resource_data.path),
            "--empty_suggestions",  str(sdk2.ResourceData(self.Parameters.problems_data).path) + "/empty_suggestions",
        ]
        execute_cmd(
            cmd_params,
            'gen_suggest_problems_dicts',
            'Failed to create dicts',
        )

        resource_data.ready()

    def on_execute(self):
        self.gen_dicts()
