import os

from sandbox import sdk2
from sandbox.projects.geobase.Geodata6BinStable.resource import GEODATA6BIN_STABLE
from sandbox.projects.ydo import get_last_released_resource, execute_cmd
from sandbox.projects.ydo import ydo_releasers


class YdoSuspiciousWorkersFinderExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoSuspiciousWorkersFinderTask(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        use_stable_resources = sdk2.parameters.Bool(
            "Use stable resources?",
            default=True,
        )
        with use_stable_resources.value[False]:
            suspicious_workers_finder_executable_resource = sdk2.parameters.Resource(
                "suspicious_workers_finder",
                resource_type=YdoSuspiciousWorkersFinderExecutable,
                required=True,
            )
            geobase_snapshot = sdk2.parameters.Resource(
                'Geobase 6 snapshot',
                resource_type=GEODATA6BIN_STABLE,
                required=True
            )

        cmd = sdk2.parameters.String(
            "Command line parameters",
            required=True,
        )

        env = sdk2.parameters.Dict(
            "Environment variables",
        )

        secret_env = sdk2.parameters.Dict(
            "Secret environment variables",
        )

    def on_execute(self):
        cmd = [
            str(get_last_released_resource(
                YdoSuspiciousWorkersFinderExecutable,
                condition=self.Parameters.use_stable_resources,
                default=self.Parameters.suspicious_workers_finder_executable_resource,
                error_msg="YdoSuspiciousWorkersFinderExecutable not found",
            ).path),
            '--geobase_file',
            str(get_last_released_resource(
                GEODATA6BIN_STABLE,
                condition=self.Parameters.use_stable_resources,
                default=self.Parameters.geobase_snapshot,
                error_msg="GEODATA6BIN_STABLE not found",
            ).path)
        ]
        cmd += self.Parameters.cmd.split()

        env = os.environ.copy()
        for env_name, value in self.Parameters.env.iteritems():
            env[env_name] = str(value)

        for env_name, vault_name in self.Parameters.secret_env.iteritems():
            env[env_name] = sdk2.Vault.data(self.owner, vault_name)

        execute_cmd(cmd, "suspicious_workers_finder", "suspicious_workers_finder failed", env=env)
