# coding: utf-8
import logging
import os

import sandbox.sdk2 as sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.ydo.parameters_view import generate_view_for_yt

logger = logging.getLogger(__name__)


def transfer_tables(yt, export_dir, result_table, limit, row_buffer_size=1000):
    result_table_path = yt.TablePath(result_table, append=True)

    tables_to_delete = []
    row_buffer = []
    table_count = 0
    for table_name in yt.list(export_dir):
        logger.info('processing table {}'.format(table_name))

        full_table_name = os.path.join(export_dir, table_name)
        for row in yt.read_table(full_table_name):
            row_buffer.append(row)

        tables_to_delete.append(full_table_name)

        if len(row_buffer) >= row_buffer_size:
            logger.info('flush!')

            yt.write_table(result_table_path, row_buffer)
            for table_to_delete in tables_to_delete:
                yt.remove(table_to_delete)

            row_buffer = []
            tables_to_delete = []

        table_count += 1
        if table_count >= limit:
            break

    if row_buffer:
        yt.write_table(result_table_path, row_buffer)
        for table_to_delete in tables_to_delete:
            yt.remove(table_to_delete)


class YdoTransferComplaintsWithVerdicts(sdk2.Task):
    """
        Перенос и мёрджинг жалоб с вердиктами антиспама
    """

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        ]

    class Parameters(generate_view_for_yt(
        check_owner=True,
        with_environ=True,
    )):
        services_complaints_export_dir = sdk2.parameters.String(
            'Services complaints export directory path',
            required=True
        )

        result_table = sdk2.parameters.String(
            'Result table to append complaints with verdicts',
            required=True
        )

        table_limit = sdk2.parameters.Integer(
            'Tables limit to transfer',
            default_value=1000
        )

        yt_cluster = sdk2.parameters.String(
            'YT cluster',
            default_value='hahn'
        )

    def on_execute(self):
        import yt.wrapper as yt

        yt.config['token'] = sdk2.Vault.data(self.owner, 'yt-token')
        yt.config['proxy']['url'] = '{}.yt.yandex.net'.format(self.Parameters.yt_cluster)

        transfer_tables(
            yt,
            self.Parameters.services_complaints_export_dir,
            self.Parameters.result_table,
            self.Parameters.table_limit,
        )
