import logging
from sandbox import sdk2
from sandbox.projects.ydo import (
    execute_cmd,
    ydo_releasers,
)
from sandbox.projects.ydo.parameters_view import generate_view


class YdoPublishCallCenterReviewsExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoPublishCallCenterReviews(sdk2.Task):

    class Parameters(generate_view(
        executable=YdoPublishCallCenterReviewsExecutable,
        check_owner=True,
        with_environ=True,
        default_env_vars={
            'YT_PROXY': 'hahn.yt.yandex.net',
        },
        default_secret_env_vars={
            'YT_TOKEN': 'yt-token',
            'SOLOMON_TOKEN': 'solomon-token',
            'TVM_SECRET': 'ydo_tvm_secret_prod',
        },
    )):

        input_table = sdk2.parameters.String('Path to input table with callcenter reviews', required=True)
        processed_table = sdk2.parameters.String('Path to table with already processed reviews', required=True)

        ugc_use_test_api = sdk2.parameters.Bool('Use test ugc api', required=True, default=False)

        solomon_project = sdk2.parameters.String('Solomon project', required=False, default='ydo')
        solomon_cluster = sdk2.parameters.String('Solomon cluster', required=False, default='sandbox_tasks')
        solomon_service = sdk2.parameters.String('Solomon service', required=False, default='call_center_reviews')
        solomon_type = sdk2.parameters.String('Solomon type', required=False)

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        logging.info('Starting executable...')
        env = self.Parameters.get_environ()
        cmd = [
            self.Parameters.executable_path,
            '--input_table', self.Parameters.input_table,
            '--processed_table', self.Parameters.processed_table,
            '--tvm_secret', env['TVM_SECRET'],
        ]
        if self.Parameters.ugc_use_test_api:
            cmd += ['--ugc_use_test_api']
        if self.Parameters.solomon_project and self.Parameters.solomon_cluster and self.Parameters.solomon_service:
            cmd += [
                '--solomon_project', self.Parameters.solomon_project,
                '--solomon_cluster', self.Parameters.solomon_cluster,
                '--solomon_service', self.Parameters.solomon_service,
                '--solomon_type', self.Parameters.solomon_type,
            ]
        execute_cmd(cmd, 'executable', 'Failed', env=self.Parameters.get_environ())
        logging.info('Done')
