import logging
import os

from sandbox import sdk2
from sandbox.common.types import misc as ctm
from sandbox.projects.ydo import execute_cmd, ydo_releasers
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.sandboxsdk.environments import PipEnvironment


class YdoUploadBalanceTransactionsToYtHandler(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ydo_releasers
    arcadia_build_path = "ydo/tools/balance/upload_balance_transactions_to_yt/bin"
    executable = True

    binary_path = sdk2.parameters.String(default='upload_balance_transactions_to_yt')


class YdoUploadBalanceTransactionsToYt(sdk2.Task):
    """Task that uploads balance transactions to yt"""

    class Parameters(generate_view(
        processor=YdoUploadBalanceTransactionsToYtHandler,
        check_owner=True,
    )):
        tokens = sdk2.parameters.YavSecret("YAV YDO_OAUTH_TOKENS secret id", required=True)

        ydb_host = sdk2.parameters.String('YDB Host', required=True)
        ydb_port = sdk2.parameters.Integer('YDB Port', default=2135, required=True)
        ydb_database = sdk2.parameters.String('YDB Database', required=True)
        ydb_home = sdk2.parameters.String('YDB Home', required=True)

        environment = sdk2.parameters.String('Environment', required=True, default='test')

    class Requirements(sdk2.Requirements):
        cores = 1
        dns = ctm.DnsType.DNS64
        environments = (
            PipEnvironment('requests'),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        logging.info('Starting executing upload_balance_transactions_to_yt')

        env = os.environ.copy()
        env['YDB_TOKEN'] = self.Parameters.tokens.data()['YDB_TOKEN']
        env['YT_TOKEN'] = self.Parameters.tokens.data()['YT_TOKEN']

        execute_cmd(
            [
                str(self.Parameters.processor_path),
                '--ydb_host', str(self.Parameters.ydb_host),
                '--ydb_port', str(self.Parameters.ydb_port),
                '--ydb_database', str(self.Parameters.ydb_database),
                '--ydb_home', str(self.Parameters.ydb_home),
                '--environment', str(self.Parameters.environment),
            ],
            'upload_balance_transactions_to_yt',
            'Failed to upload balance transactions to yt',
            env=env,
        )

        logging.info('Done')
