import logging
import os

from sandbox import sdk2
from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo import ydo_releasers, get_now_utc
from sandbox.projects.ydo.parameters_view import generate_view
from sandbox.projects.resource_types import MR_GEMINICL


class YdoOneWorkerBuildExecutable(sdk2.Resource):
    releasable = True
    releasers = ydo_releasers


class YdoOneWorkerBuildExport(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(generate_view(build_one_worker_executable=YdoOneWorkerBuildExecutable, mr_geminicl_executable=MR_GEMINICL)):
        working_dir = sdk2.parameters.String('Working dir', required=True)
        yt_ttl = sdk2.parameters.Integer('YT ttl', required=True)

    def export_one_worker_table(self):
        env = os.environ.copy()
        env['YT_TOKEN'] = sdk2.Vault.data(self.owner, 'yt-token')
        env['YT_PROXY'] = 'hahn.yt.yandex.net'
        env['YT_LOG_LEVEL'] = 'DEBUG'
        env['YQL_TOKEN'] = sdk2.Vault.data(self.owner, 'yql-token')

        logging.info('Exporting one_worker`s wizards` data')
        execute_cmd(
            [
                self.Parameters.build_one_worker_executable_path,
                '--working_dir', self.Context.working_dir,
                '--mr_gemincl', self.Parameters.mr_geminicl_executable_path,
                '--yt_ttl', str(self.Parameters.yt_ttl),
            ],
            'build one_worker data',
            'Failed to build one_worker data',
            env=env
        )

    def on_execute(self):
        self.Context.working_dir = os.path.join(self.Parameters.working_dir, str(get_now_utc()))

        with self.memoize_stage.export_one_worker_table:
            self.export_one_worker_table()
