from sandbox import sdk2

from sandbox.projects.ydo import execute_cmd
from sandbox.projects.ydo import resource_types
from sandbox.projects.ydo.parameters_view import generate_view, with_config

import logging
logger = logging.getLogger()


class YdoYtMonthlyMerger(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(
        with_config(
            generate_view(
                ydo_yt_monthly_merger_executable=resource_types.YdoYtMonthlyMergerExecutable,
                check_owner=True,
                with_environ=True
            ),
            'ydo/devops/yt_tools/yt_table_monthly_merger/bin/config',
            [
                ('production', 'production_config.yaml'),
                ('testing', 'testing_config.yaml'),
            ]
        )
    ):
        pass

    def on_execute(self):
        cmd = [self.Parameters.ydo_yt_monthly_merger_executable_path, 'config', self.Parameters.config_path]
        execute_cmd(
            cmd,
            'ydo_yt_monthly_merger',
            'ydo_yt_monthly_merger failed',
            env=self.Parameters.get_environ(),
            fail_on_error=False
        )
