from sandbox import sdk2
from sandbox.sandboxsdk import environments

import os
import json


class YdoYtTableToResource(sdk2.Task):
    """
        Dump YT table as Sandbox resource
    """

    class Parameters(sdk2.Task.Parameters):
        yt_token_vault_name = sdk2.parameters.String('Name of the vault record with YT token', default='yt-token', required=True)

        yt_proxy = sdk2.parameters.String('YT proxy', default='hahn.yt.yandex.net', required=True)

        yt_path = sdk2.parameters.String('YT table path', required=True)

        resource_type = sdk2.parameters.String('Resource type', default='OTHER_RESOURCE', required=True)

        resource_description = sdk2.parameters.String('Resource description')

        attributes = sdk2.parameters.Dict('Attributes for created resource', default={})

    class Requirements(sdk2.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        )

    def on_execute(self):
        import yt.wrapper as yt

        token = sdk2.Vault.data(self.owner, self.Parameters.yt_token_vault_name)
        yt_client = yt.YtClient(proxy=self.Parameters.yt_proxy, token=token)

        yt_rows = list(yt_client.read_table(self.Parameters.yt_path))
        local_target_path = os.path.basename(self.Parameters.yt_path)
        with open(local_target_path, 'wb') as f:
            json.dump(yt_rows, f, ensure_ascii=False)

        resource_type = sdk2.Resource[self.Parameters.resource_type]
        dict_resource = resource_type(self, self.Parameters.resource_description, local_target_path, **self.Parameters.attributes)
        sdk2.ResourceData(dict_resource).ready()
