import logging

from sandbox import sdk2
from sandbox.projects.ydo import ydo_releasers, execute_cmd
from sandbox.projects.ydo.parameters_view import generate_view

logger = logging.getLogger(__name__)


# Resource types
class YdoYtToRtmrExecutable(sdk2.Resource):
    """
        Prepare data to use in rtmr
    """
    executable = True
    releasable = True
    releasers = ydo_releasers


class YdoYtTableToRTMR(sdk2.Task):

    class Parameters(
        generate_view(
            ydo_yt_to_rtmr=YdoYtToRtmrExecutable,
            check_owner=True,
            with_environ=True,
            default_env_vars={
                'YT_CLUSTER': 'hahn'
            },
            default_secret_env_vars={
                'YQL_TOKEN': 'YQL_TOKEN',
                'LOGBROKER_TVM_SECRET': 'ydo_tvm_secret_prod'
            }
        )
    ):
        query = sdk2.parameters.String(
            "YQL Query.",
            multiline=True,
            required=True
        )

        rtmr_table_name = sdk2.parameters.String(
            "RTMR table name",
            required=True
        )

        lb_batch_size = sdk2.parameters.Integer(
            "Logbroker messages quantity to write into topic",
            default=30,
            required=True
        )

        key_column = sdk2.parameters.String(
            "Key column name",
            required=True
        )

        sub_key_column = sdk2.parameters.String(
            "SubKey column name",
            required=True
        )

    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        cmd = [
            self.Parameters.ydo_yt_to_rtmr_path,
            '--key_column', self.Parameters.key_column,
            '--subkey_column', self.Parameters.sub_key_column,
            '--rtmr_table_name', self.Parameters.rtmr_table_name,
            '--yql_query', self.Parameters.query,
            '--logbroker_batch_size', str(self.Parameters.lb_batch_size),
        ]

        execute_cmd(cmd, 'yt_to_rtmr', 'Failed export yt data to rtmr', env=self.Parameters.get_environ())
