from sandbox import sdk2
from sandbox.common.types import resource as ctr

yf_releasers = [
    'knuzhdin',
    'mbabich',
    'beloshabskiy',
    'd-mokhnatkin',
    'robot-skc',
    'hor911',
    'uzhas',
]


class YfBreakpad(sdk2.Resource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = yf_releasers


class YfCliLinux(sdk2.Resource):
    executable = True
    releasable = True
    releasers = yf_releasers
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE


class YfSliClient(sdk2.Resource):
    executable = True
    releasable = True
    releasers = yf_releasers
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
