from sandbox import sdk2

import sandbox.sdk2.paths as paths
import sandbox.projects.release_machine.components.all as rmc
import sandbox.projects.release_machine.input_params2 as rm_params2
from sandbox.sdk2.helpers import subprocess as subprocess

from resources import TUTOR_ARCHIVE


class CreateTutorArchiveResource(sdk2.Task):
    class Parameters(rm_params2.ComponentNameResources):
        tutor_binary = sdk2.parameters.Resource('tutor_binary', required=False)
        tutor_add_config = sdk2.parameters.Resource('tutor_add_config', required=True)
        tutor_extractor = sdk2.parameters.Resource('tutor_extractor', required=True)
        custom_script = sdk2.parameters.Resource('custom_script', required=True)

    class Context(sdk2.Context):
        child_task = None

    def copy_resource_to(self, dir_name, resource):
        paths.copy_path(str(sdk2.ResourceData(resource).path), str(dir_name))

    def copy_last_trunk_resource_to(self, dir_name, resource_name):
        rs = sdk2.Resource[resource_name].find(attrs=dict(arcadia_trunk="True"))
        self.copy_resource_to(dir_name, rs.first())

    def copy_last_resource_to(self, dir_name, resource_name, branch_n):
        num = int(branch_n)
        rs = sdk2.Resource[resource_name].find(
            attrs=dict(released="stable", testenv_database="ws-tutor-{}".format(num)))
        empty = True
        while empty:
            rs = rs.limit(1)
            for resource in rs:
                empty = False
                print ("Loading resource with id " + str(resource.id))
                self.copy_resource_to(dir_name, resource)
                break
            else:
                num -= 1
                rs = sdk2.Resource[resource_name].find(
                    attrs=dict(released="stable", testenv_database="ws-tutor-{}".format(num)))

    def on_execute(self):
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        archive_name = "archive.tar.gz"
        dir_name = self.path('some_directory')

        paths.make_folder(dir_name)

        self.copy_resource_to(dir_name, self.Parameters.tutor_add_config)
        self.copy_resource_to(dir_name, self.Parameters.custom_script)
        self.copy_resource_to(dir_name, self.Parameters.tutor_extractor)
        self.copy_last_trunk_resource_to(dir_name, "EVLOGDUMP_EXECUTABLE")
        if self.Parameters.tutor_binary:
            self.copy_resource_to(dir_name, self.Parameters.tutor_binary)
        else:
            self.copy_last_resource_to(dir_name, "EDUCATION_EXECUTABLE", c_info.prev_branch_num)

        archive_resource = sdk2.ResourceData(TUTOR_ARCHIVE(
            self, "Archive with APP_HOST_BENCHMARK-ready tutor executable", archive_name
        ))
        command = ["tar", "cvzf", str(archive_resource.path), 'some_directory']
        with sdk2.helpers.ProcessLog(self, logger="tar") as pl:
            subprocess.Popen(command, stdout=pl.stdout, stderr=subprocess.STDOUT).wait()

        archive_resource.ready()
