from sandbox import sdk2

from sandbox.projects.websearch.upper.RequestSampler import RequestSampler
from sandbox.projects.app_host.resources import APP_HOST_JSON_CONTEXTS
import sandbox.common.types.task as ctt

import json

class GenerateTutorAppHostRequests(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        number_of_requests = sdk2.parameters.Integer("number of requests", default=300)

    class Context(sdk2.Task.Context):
        child_task_id = None

    def on_execute(self):
        if self.Context.child_task_id is None:
            task = RequestSampler(self, notifications=self.Parameters.notifications, create_sub_task=False,
                                  request_sampler=sdk2.Resource["REQUEST_SAMPLER_EXECUTABLE"].find().first(),
                                  number_of_requests=self.Parameters.number_of_requests,
                                  sources="EDUCATION_BACKEND",
                                  graphs="TUTOR",
                                  output_type="app-host-json",
                                  yt_token_vault_key="freshness_token")
            self.Context.child_task_id = task.id
            task.enqueue()
            raise sdk2.WaitTask([task], ctt.Status.Group.FINISH)
        else:
            task = sdk2.Task[self.Context.child_task_id]
            resource = APP_HOST_JSON_CONTEXTS.find(task=task).first()
            resource_data = sdk2.ResourceData(resource)
            resource_path = resource_data.path

            with open(str(resource_path)) as file:
                queries = file.readlines()

            modified_queries = []
            for query in queries:
                res = {}
                for item in json.loads(query)["answers"]:
                    for k, v in item.iteritems():
                        if k == "name":
                            continue
                        if k not in res:
                            res[k] = []
                        res[k].extend(v)
                res["name"] = "INIT"
                res = [res]
                modified_query = json.dumps(res)
                modified_queries.append(modified_query)

            result_resource = sdk2.ResourceData(APP_HOST_JSON_CONTEXTS(self, "", "result.txt"))
            output_path = result_resource.path
            modified_queries = "\n".join(modified_queries)

            with open(str(output_path), "w") as file:
                file.write(modified_queries)
            result_resource.ready()
