from sandbox import sdk2

from sandbox.projects.app_host.resources import APP_HOST_JSON_CONTEXTS
from sandbox.projects.younglings.generate_tutor_requests import GenerateTutorAppHostRequests

from sandbox.common.types.task import Status

class GetLastTutorAppHostRequests(sdk2.Task):
    def on_execute(self):
        task = GenerateTutorAppHostRequests.find().first()
        resource = APP_HOST_JSON_CONTEXTS.find(task=task, status=Status.SUCCESS).first()
        resource_data = sdk2.ResourceData(resource)
        resource_path = resource_data.path
        with open(str(resource_path)) as file:
            content = file.read()

        result_resource = sdk2.ResourceData(APP_HOST_JSON_CONTEXTS(self, "", "result.txt"))
        result_path = result_resource.path
        with open(str(result_path), 'w') as file:
            file.write(content)

        result_resource.ready()
