# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from resources import *
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.constants as consts


class BuildTrunkTutor(nanny.ReleaseToNannyTask, CommonBuildTask):
    type = 'BUILD_TRUNK_TUTOR'

    client_tags = ctc.Tag.Group.LINUX

    execution_space = 70000

    def initCtx(self):
        CommonBuildTask.initCtx(self)
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.YMAKE_BUILD_SYSTEM
        self.ctx[consts.BUILD_BUNDLE_KEY] = False

    TARGET_RESOURCE_TYPES = (
        EDUCATION_EXECUTABLE
    )


__Task__ = BuildTrunkTutor
