# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.sandboxsdk import environments
import requests
import json

NANNY_URL = 'https://nanny.yandex-team.ru/'
SERVICE_ID = 'tutor_morda_cards'
TASK_TYPE = 'UPDATE_TUTOR_UUIDS'
RESOURCE_TYPE = 'OTHER_RESOURCE'


class UpdateTutorUuids(sdk2.Task):

    class Parameters(sdk2.Parameters):
        YQL_TOKEN_OWNER = sdk2.parameters.String('YQL token owner')
        YQL_TOKEN_NAME = sdk2.parameters.String('YQL token name')
        NANNY_TOKEN_OWNER = sdk2.parameters.String('Nanny token owner')
        NANNY_TOKEN_NAME = sdk2.parameters.String('Nanny token name')
        CUSTOM_UUIDS_CLUSTER = sdk2.parameters.String('Custom uuids cluster')
        CUSTOM_UUIDS_PATH = sdk2.parameters.String('Custom uuids path')

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment('yql'),
            environments.PipEnvironment('yandex-yt')
        ]

    def on_execute(self):
        from yql.api.v1.client import YqlClient

        resource = resource_types.OTHER_RESOURCE(
            self, "uuids", "ids.txt", ttl=180
        )

        client = YqlClient(
            db='hahn',
            token=sdk2.Vault.data(
                self.Parameters.YQL_TOKEN_OWNER,
                self.Parameters.YQL_TOKEN_NAME
            ))

        yuid_repetitors = u"$yuid_repetitors= ( \
                           SELECT cast(yandexuid as string) AS yandexuid \
                           FROM `home/crypta/production/profiles/export/profiles_for_14days` \
                           WHERE DictContains(Yson::ConvertToDict(lal_internal), '1119')); "

        cryptaids_repetitors = u"$cryptaids_repetitors = ( \
                                SELECT target_id AS crypta_id \
                                FROM $yuid_repetitors AS a \
                                INNER JOIN `home/crypta/public/matching/by_id/yandexuid/crypta_id` AS b \
                                ON  a.yandexuid = b.id); "

        uuid_repetitors = u"$uuid_repetitors = ( \
                           SELECT target_id AS `uuid` \
                           FROM $cryptaids_repetitors  AS c \
                           INNER JOIN `home/crypta/public/matching/by_id/crypta_id/uuid` AS d \
                           ON c.crypta_id=d.id); "

        pp_uids = u"$pp_uids = ( \
                   SELECT id AS `uuid` \
                   FROM `home/crypta/public/ids_storage/uuid/app_metrica_month` \
                   WHERE app_id = 'ru.yandex.searchplugin'); "

        uuids = u"$uuids = ( \
                 SELECT `uuid` AS `uuid` \
                 FROM $uuid_repetitors AS e \
                 LEFT SEMI JOIN $pp_uids AS f \
                 ON e.`uuid` = f.`uuid`); "

        select_uuids = u"SELECT DISTINCT `uuid` \
                        FROM $uuids"

        query = yuid_repetitors + cryptaids_repetitors + uuid_repetitors + pp_uids + uuids + select_uuids

        request = client.query(query, syntax_version=1)

        request.run()

        result = ""

        for table in request.get_results():
            table.fetch_full_data()
            for row in table.rows:
                for cell in row:
                    result += str(cell) + '\n'

        client = YqlClient(
            db=self.Parameters.CUSTOM_UUIDS_CLUSTER,
            token=sdk2.Vault.data(
                self.Parameters.YQL_TOKEN_OWNER,
                self.Parameters.YQL_TOKEN_NAME
            ))
        query = "PRAGMA yt.InferSchema = '1'; SELECT `uuid` FROM `" + self.Parameters.CUSTOM_UUIDS_PATH + "`"
        request = client.query(query, syntax_version=1)
        request.run()

        for table in request.get_results():
            table.fetch_full_data()

            for row in table.rows:
                for cell in row:
                    result += str(cell) + '\n'

        resource.path.write_bytes(result)

        OAUTH_TOKEN = sdk2.Vault.data(self.Parameters.NANNY_TOKEN_OWNER, self.Parameters.NANNY_TOKEN_NAME)
        task_id = self.id
        resource_id = resource.id

        session = requests.Session()
        session.headers['Authorization'] = 'OAuth {}'.format(OAUTH_TOKEN)
        session.headers['Content-Type'] = 'application/json'
        resources_url = NANNY_URL + 'v2/services/{}/runtime_attrs/'.format(SERVICE_ID)

        response = session.get(resources_url)

        if not response.ok:
            raise Exception("Sending data to Nanny failed:\n" + response.status_code + "\n" + response.text)

        response_dict = response.json()
        snapshot_id = response_dict['_id']
        content = response_dict['content']

        for resource in content['resources']['sandbox_files']:
            if resource['task_type'] == TASK_TYPE and resource['resource_type'] == RESOURCE_TYPE:
                resource['task_id'] = str(task_id)
                resource['resource_id'] = str(resource_id)
        request = {
            'snapshot_id': snapshot_id,
            'content': content,
            'comment': 'Update ids.txt',
        }

        response = session.put(resources_url, data=json.dumps(request))
        if not response.ok:
            raise Exception("Sending data to Nanny failed:\n" + response.status_code + "\n" + response.text)

        response = session.get(resources_url)
        response_dict = response.json()
        snapshot_id = response_dict['_id']

        activate_snapshot_url = NANNY_URL + 'v2/services/tutor_morda_cards/events/'
        activate_snapshot_json = {
            "type": "SET_TARGET_STATE",
            "content": {
                "is_enabled": True,
                "snapshot_id": snapshot_id,
                "comment": "Update ids.txt",
                "prepare_recipe": "default",
                "recipe": "default"
            }
        }

        response = session.post(activate_snapshot_url, data=json.dumps(activate_snapshot_json))

        if not response.ok:
            raise Exception("Activating snapshot at Nanny failed:\n" + response.status_code + "\n " + response.text)
