import os
import logging
from sandbox.sdk2.helpers import subprocess as sp
# import subprocess

from sandbox import sdk2
from sandbox import common


class YpBackup(sdk2.Task):

    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        yp_max_backups = sdk2.parameters.Integer("max backup count", required=True)
        yp_source_cluster = sdk2.parameters.String("yp source cluster", required=True)
        yt_destination_clusters = sdk2.parameters.String("yt destination clusters", required=True)
        yt_destination_path = sdk2.parameters.String("yt destination path", required=True)
        resource_id = sdk2.parameters.Integer("Specify resource id explicitly to allow cluster-by-cluster task update", required=True)
        test = False

    class Context(sdk2.Task.Context):
        data_name = "yp_node_in_multiple_segments"

    def on_execute(self):

        def sync_file(resource_id):
            resource_data = sdk2.ResourceData(resource_id)  # synchronizing resource data on disk
            return resource_data.path

        secrets = sdk2.yav.Secret("sec-01edxz4qkmk814cb240ewbtdx4").data()

        os.environ["YT_TOKEN"] = secrets["yt_token"]
        os.environ["SOLOMON_TOKEN"] = secrets["solomon_token"]

        yp_admin_resource_version = sdk2.Resource[self.Parameters.resource_id]

        logging.debug("yp_admin_resource_version=%s", yp_admin_resource_version)
        # backup_file = os.getcwd() + "/" + "backup"
        # download_file("https://proxy.sandbox.yandex-team.ru/{}".format(yp_admin_resource_version), backup_file)
        backup_file = str(sync_file(yp_admin_resource_version)) + "/backup"
        logging.debug("backup_file=%s", backup_file)
        os.chmod(backup_file, 0o777)
        args = (
            backup_file,
            "--yp_cluster", str(self.Parameters.yp_source_cluster),
            "--yt_clusters", str(self.Parameters.yt_destination_clusters),
            "--yt_base_path", str(self.Parameters.yt_destination_path),
            "--max_backups", str(self.Parameters.yp_max_backups)
        )

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("yp_backup")) as pl:
            pr = sp.Popen(' '.join(map(str, args)), shell=True, stdout=pl.stdout, stderr=sp.STDOUT)
            pr.wait()
            if pr.returncode != 0:
                raise common.errors.TaskFailure("Something went wrong")
