# -*- coding: utf-8 -*-

import logging
import os
import tempfile

from sandbox import sdk2
from sandbox.projects.common import constants as consts
from sandbox.projects.common.arcadia import sdk
from sandbox.projects.infra.common import get_arcadia
from sandbox.projects.common.build.BuildArcadiaProjectForAll import BuildArcadiaProjectForAll
from sandbox.projects.yp.common import YP_MASTER_RELEASERS


class YpCliBinary(sdk2.Resource):
    executable = True
    releasable = True
    releasers = YP_MASTER_RELEASERS
    auto_backup = True
    arcadia_build_path = "infra/yp_cli/"


class BuildYpCli(BuildArcadiaProjectForAll):
    type = 'BUILD_YP_CLI'

    target_to_host_map = {
        'linux': consts.SANDBOX_LINUX_UBUNTU_12_PRECISE,
        'darwin': consts.SANDBOX_LINUX_UBUNTU_12_PRECISE,
    }

    toolchain_map = {
        'linux': 'DEFAULT-LINUX-X86_64',
        'darwin': 'DEFAULT-DARWIN-X86_64',
    }

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl("Svn url for arcadia", required=True)
        test = False

        with sdk2.parameters.Output:
            data_resource = sdk2.parameters.Resource("Binary", resource_type=YpCliBinary)

    class Context(sdk2.Task.Context):
        data_name = "yp_cli_binary"

    # input_parameters = YaPackage.input_parameters
    #
    # def on_execute(self):
    #     YaPackage.on_execute(self)

    def build(self):
        target = YpCliBinary.arcadia_build_path
        build_dir = tempfile.mkdtemp()

        with get_arcadia(self.Parameters.arcadia_url) as arcadia:
            logging.info("build  binary...")
            sdk.do_build(
                consts.YMAKE_BUILD_SYSTEM,
                source_root=arcadia,
                build_type=consts.RELEASE_BUILD_TYPE,
                targets=[target],
                results_dir=build_dir,
                clear_build=True,
                test=self.Parameters.test,
            )
            logging.info("binary built")

        os.rename(os.path.join(build_dir, target), str(self.Parameters.data_resource.path))


__Task__ = BuildYpCli
