# -*- coding: utf-8 -*-

import logging
import os
import tempfile
from shutil import copytree

from sandbox import sdk2
from sandbox.projects.common import constants as consts
from sandbox.projects.common.arcadia import sdk
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2
from sandbox.projects.infra.common import get_arcadia
from sandbox.projects.yp.common import YP_MASTER_RELEASERS


class YpEmergencyBreakResources(sdk2.Resource):
    executable = False
    releasable = True
    releasers = YP_MASTER_RELEASERS
    auto_backup = True
    arcadia_build_path = "infra/yp/emergency_break"


class BuildYpEmergencyBreak(ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl("Svn url for arcadia", required=True)
        test = False

        with sdk2.parameters.Output:
            data_resource = sdk2.parameters.Resource("Resources", resource_type=YpEmergencyBreakResources)

    class Context(sdk2.Task.Context):
        data_name = "resources"

    def on_execute(self):
        self.Parameters.data_resource = YpEmergencyBreakResources(
            self, self.Parameters.description, self.Context.data_name, ttl=90
        )

        self.build()
    # input_parameters = YaPackage.input_parameters
    #
    # def on_execute(self):
    #     YaPackage.on_execute(self)

    def build(self):
        target = YpEmergencyBreakResources.arcadia_build_path

        with get_arcadia(self.Parameters.arcadia_url) as arcadia:
            logging.info("building resources...")

            logging.info("Moving from {} to {}".format(os.path.join(arcadia, target), str(self.Parameters.data_resource.path)))
            copytree(os.path.join(arcadia, target), str(self.Parameters.data_resource.path))

    def on_release(self, additional_parameters):
        ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
