# -*- coding: utf-8 -*-

import logging
import os
import shutil
import tempfile

from sandbox import sdk2
from sandbox.projects.common import constants as consts
from sandbox.projects.common.arcadia import sdk
from sandbox.projects.infra.common import get_arcadia
from sandbox.projects.yp.common import YP_MASTER_RELEASERS


class YpSimtoolBinary(sdk2.Resource):
    executable = True
    releasable = True
    releasers = YP_MASTER_RELEASERS
    auto_backup = True
    arcadia_build_path = "yp/scheduler_simulator/simtool"


class BuildYpSimtool(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl("Svn url for arcadia", required=True)
        test = False

        with sdk2.parameters.Output:
            data_resource = sdk2.parameters.Resource("Binary", resource_type=YpSimtoolBinary)

    class Context(sdk2.Task.Context):
        data_name = "yp_simtool"

    def on_execute(self):
        self.Parameters.data_resource = YpSimtoolBinary(
            self, self.Parameters.description, self.Context.data_name, ttl=90
        )

        self.build()

    def build(self):
        target = YpSimtoolBinary.arcadia_build_path
        build_dir = tempfile.mkdtemp()

        with get_arcadia(self.Parameters.arcadia_url) as arcadia:
            logging.info("build yp_cluster_size_monitoring binary...")
            sdk.do_build(
                consts.YMAKE_BUILD_SYSTEM,
                source_root=arcadia,
                build_type=consts.RELEASE_BUILD_TYPE,
                targets=[target],
                results_dir=build_dir,
                clear_build=True,
                test=self.Parameters.test,
            )
            logging.info("binary built")

        shutil.move(os.path.join(build_dir, target), str(self.Parameters.data_resource.path))

    def on_release(self, additional_parameters):
        sdk2.Task.on_release(self, additional_parameters)
