# coding=utf-8

# from https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/metrika/qa/lxc_containers/__init__.py

import sandbox.common.types.misc as ctm
from sandbox.projects.sandbox import LXC_CONTAINER
from sandbox.projects.sandbox.sandbox_lxc_image import (
    SandboxLxcImage,
    UbuntuRelease
)

CUSTOM_REPOS_TRUSTY = [
    # 01-yandex-trusty.list
    'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty stable/amd64/',
    'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty stable/all/',
    'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty testing/all/',
    'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty testing/amd64/',
    'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty prestable/amd64/',
    'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty prestable/all/',
    # common.list
    'deb http://common.dist.yandex.ru/common stable/all/',
    'deb http://common.dist.yandex.ru/common stable/amd64/',
    'deb http://common.dist.yandex.ru/common testing/amd64/',
    'deb http://common.dist.yandex.ru/common prestable/all/',
    'deb http://common.dist.yandex.ru/common prestable/amd64/',
    'deb http://common.dist.yandex.ru/common testing/all/',
    # system.list
    'deb http://system.dist.yandex.ru/system configs/all/',
    # yandex.list
    'deb http://yandex-trusty.dist.yandex.ru/yandex-trusty stable/amd64/',
    'deb http://common.dist.yandex.ru/common stable/amd64/',
    'deb http://yandex.dist.yandex.ru/yandex stable/amd64/',
    'deb http://yandex.dist.yandex.ru/yandex stable/all/',
    # git-core ppa trusty
    'deb http://ppa.launchpad.net/git-core/ppa/ubuntu trusty main'
]

CUSTOM_PACKAGES = [
    'fakeroot',
    'alien',
]

CUSTOM_SCRIPT = """
set -o errexit
set -o xtrace
tee /etc/apt/preferences.d/00-pin<<EOF
Package: *
Pin: release a=stable
Pin-Priority: 500
EOF

apt-get install --assume-yes --force-yes mc telnet git curl wget ca-certificates devscripts jq python python-pip g++ python-dev python-virtualenv python-nile

# PyPI
tee /etc/pip.conf <<EOF
[global]
index-url = https://pypi.yandex-team.ru/simple
timeout = 120
EOF

pip install  setuptools
pip install pandas requests==2.14.2 yql==1.2.44
"""


class CreateLauncherLxcContainer(SandboxLxcImage):
    """
    Сборка контейера с окружением включающем nile
    """

    class Requirements(SandboxLxcImage.Requirements):
        dns = ctm.DnsType.DNS64
        privileged = True  # to run apt-get installs in build-all script

    class Parameters(SandboxLxcImage.Parameters):
        ram = 1024  # in MiB
        disk_space = 2 * 1024
        kill_timeout = 60 * 60  # 1 hour
        description = "LXC for Launcher Ammo Generation"
        resource_description = SandboxLxcImage.Parameters.resource_description(
            default="Launcher Ammo Generation Environment"
        )
        custom_image = SandboxLxcImage.Parameters.custom_image(default=True)
        ubuntu_release = SandboxLxcImage.Parameters.ubuntu_release(default=UbuntuRelease.TRUSTY)
        resource_type = SandboxLxcImage.Parameters.resource_type(default=LXC_CONTAINER.name)
        custom_repos = SandboxLxcImage.Parameters.custom_repos(default='\n'.join(CUSTOM_REPOS_TRUSTY))
        custom_packages = SandboxLxcImage.Parameters.custom_packages(default=' '.join(CUSTOM_PACKAGES))
        custom_script = SandboxLxcImage.Parameters.custom_script(default=CUSTOM_SCRIPT.strip())
        custom_attrs = SandboxLxcImage.Parameters.custom_attrs(default={'ttl': 'inf', 'launcher lxc': 'v1'})
