# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.tank.load_resources.resources import AMMO_FILE
from sandbox.projects.sandbox import LXC_CONTAINER

the_releasers = ['rtuaev']


class LauncherLxcContainer(LXC_CONTAINER):
    """
    LXC image for ammo generation and other service tasks
    """


class LauncherTankConfig(sdk2.Resource):
    """
    Launcher config
    """
    releasable = True
    executable = False
    releasers = the_releasers

    file_hash = sdk2.Attributes.String("Hash of config file", required=True)


class LauncherAmmoGenerator(sdk2.Resource):
    """
    Generates ammo from logs on YT
    """
    releasable = True
    executable = True
    releasers = the_releasers


class LauncherAmmo(AMMO_FILE):
    """
    Ammo for shooting Launcher instances
    """
    releasable = True
    executable = False
    releasers = the_releasers

    for_date = sdk2.Attributes.String("For date", required=True)
    ammo_count = sdk2.Attributes.Integer("Number of requests", required=True)


class LauncherAmmoUuids(sdk2.Resource):
    """
    Ammo for shooting Launcher instances
    """
    releasable = True
    executable = False
    releasers = the_releasers

    for_date = sdk2.Attributes.String("For date", required=True)


class LauncherShootingResult(sdk2.Resource):
    """
    Shooting results
    """
    releasable = False
    executable = False
    releasers = the_releasers
