# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.nanny.common.gobabygo_parameters import GitRefIdParameter, GitRefShaParameter, ReleaseParameter

from sandbox.projects.yt.bundle_tasks.common import YtBuildBundleTask
from sandbox.projects.yt.bundle_tasks.resource_types import YT_OTSDB_COLLECTOR_BUNDLE


class YtBuildOTSDBCollectorBundle(SandboxTask, YtBuildBundleTask):
    """
    Сборка tarball с исполняемыми файлами OTSDB Collector для YT Spinach
    """
    type = 'YT_BUILD_OTSDB_COLLECTOR_BUNDLE'

    GIT_REPO = 'yt-otsdb-collector'
    BUNDLE_NAME = 'yandex-{}'.format(GIT_REPO)

    input_parameters = [
        GitRefIdParameter,
        GitRefShaParameter,
        ReleaseParameter
    ]

    def on_execute(self):
        self._checkout()
        self._build()
        self._package_bundle(
            files={
                'bin/yt-otsdb-collector': 'usr/bin/'
            }
        )
        if self._do_release:
            self._release_bundle(
                arch='linux',
                resource_type=YT_OTSDB_COLLECTOR_BUNDLE,
            )


__Task__ = YtBuildOTSDBCollectorBundle
