# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.nanny.common.gobabygo_parameters import GitRefIdParameter, GitRefShaParameter, ReleaseParameter

from sandbox.projects.yt.bundle_tasks.common import YtBuildBundleTask
from sandbox.projects.yt.bundle_tasks.resource_types import YT_SOLOMON_BRIDGE_BUNDLE


class YtBuildSolomonBridgeBundle(SandboxTask, YtBuildBundleTask):
    """
    Сборка tarball с исполняемыми файлами Solomon Bridge для YT Spinach
    """
    type = 'YT_BUILD_SOLOMON_BRIDGE_BUNDLE'

    GIT_REPO = 'yt-otsdb-collector'
    BUNDLE_NAME = 'yandex-yt-solomon-bridge'

    input_parameters = [
        GitRefIdParameter,
        GitRefShaParameter,
        ReleaseParameter
    ]

    def on_execute(self):
        self._checkout()
        self._build()
        self._package_bundle(
            files={
                'bin/yt-solomon-bridge': 'usr/bin/'
            }
        )
        if self._do_release:
            self._release_bundle(
                arch='linux',
                resource_type=YT_SOLOMON_BRIDGE_BUNDLE,
            )


__Task__ = YtBuildSolomonBridgeBundle
