# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.nanny.common.gobabygo_parameters import GitRefIdParameter, GitRefShaParameter, ReleaseParameter

from sandbox.projects.yt.bundle_tasks.common import YtBuildBundleTask
from sandbox.projects.yt.bundle_tasks.resource_types import YT_SPINACH_BUNDLE


class YtBuildSpinachBundle(SandboxTask, YtBuildBundleTask):
    """
    Сборка tarball с исполняемыми файлами YT Spinach
    """
    type = 'YT_BUILD_SPINACH_BUNDLE'

    BUNDLE_NAME = 'spinach'

    input_parameters = [
        GitRefIdParameter,
        GitRefShaParameter,
        ReleaseParameter
    ]

    def on_execute(self):
        self._checkout()
        self._build()
        self._package_bundle(
            dirs={
                'bin': 'usr/'
            }
        )
        if self._do_release:
            self._release_bundle(
                arch='linux',
                resource_type=YT_SPINACH_BUNDLE,
            )


__Task__ = YtBuildSpinachBundle
