# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.nanny.common.gobabygo_parameters import GitRefIdParameter, GitRefShaParameter, ReleaseParameter

from sandbox.projects.yt.bundle_tasks.common import YtBuildBundleTask
from sandbox.projects.yt.bundle_tasks.resource_types import YT_SPINACH_SENSORS_BUNDLE


class YtBuildSpinachSensorsBundle(SandboxTask, YtBuildBundleTask):
    """
    Сборка tarball со скриптами-сенсорами для YT Spinach
    """
    type = 'YT_BUILD_SPINACH_SENSORS_BUNDLE'

    GIT_REPO = 'spinach'
    BUNDLE_NAME = 'spinach-sensors'

    input_parameters = [
        GitRefIdParameter,
        GitRefShaParameter,
        ReleaseParameter
    ]

    def on_execute(self):
        self._checkout()
        self._package_bundle(
            dirs={
                'src_collectors': 'usr/share/spinach'
            }
        )
        if self._do_release:
            self._release_bundle(
                arch='linux',
                resource_type=YT_SPINACH_SENSORS_BUNDLE,
            )


__Task__ = YtBuildSpinachSensorsBundle
