# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

spinach_releasers = [
    'YT',
    'YT_ADMIN',
    'YT_ROBOT',
]

spinach_subscribers = [
    'yaroslavzh',
    'alximik',
]


class YT_SPINACH_BUNDLE(AbstractResource):
    """
    YT Spinach monitoring binaries
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = spinach_releasers
    release_subscribers = spinach_subscribers


class YT_SPINACH_SENSORS_BUNDLE(AbstractResource):
    """
    YT Spinach monitoring sensor scripts
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = spinach_releasers
    release_subscribers = spinach_subscribers


class YT_OTSDB_COLLECTOR_BUNDLE(AbstractResource):
    """
    YT OTSDB Collector for Spinach binaries
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = spinach_releasers
    release_subscribers = spinach_subscribers


class YT_SOLOMON_BRIDGE_BUNDLE(AbstractResource):
    """
    YT Solomon bridge for Spinach binaries
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = spinach_releasers
    release_subscribers = spinach_subscribers
