# -*- coding: utf-8

from sandbox.projects.yt.ci_tasks.configs.YtBuildOdinDaemonConfig import YtBuildOdinDaemonConfig

from sandbox.projects.yt.common import YtClusters, ArcadiaCheckoutTask
from sandbox.projects.yt.common.resources import YtConfigResource

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment

import os


class YtBuildOdinWebServiceConfig(YtBuildOdinDaemonConfig):
    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.String("Revision", default=None, required=False)

    class Requirements(sdk2.Task.Requirements):
        max_restarts = 3
        disk_space = 10 * 1024
        environments = (
            PipEnvironment("functools32", version="3.2.3-2"),
            PipEnvironment("pyrsistent", version="0.15.5"),
            PipEnvironment("jsonschema", version="3.0.1", custom_parameters=["--no-deps"]),
        )

    def set_variables(self):
        self.ctx = {
            "checkout_data": {
                "odin": ArcadiaCheckoutTask("/yt/odin/configs", "configs", self.Parameters.revision),
                "checks": ArcadiaCheckoutTask("/yt/odin-checks/bin", "checks", None),
            },
            "config_template": "configs/webservice.config.template.json",
            "validation_schema": "configs/webservice.schema.json",
            "output_file": "webservice.config.json",
            "skip_clusters": ["marx"],
            "output_resources": [(YtConfigResource, "webservice.config.json")]
        }

    def _list_checks(self):
        result = []
        checks_path = self._get_path("checks")
        for check_name in os.listdir(checks_path):
            if check_name.startswith("."):
                continue
            check_path = os.path.join(checks_path, check_name)
            if not os.path.isdir(check_path):
                continue
            result.append(check_name)
        return result

    def build_context(self):
        self.ctx["yt_clusters"] = YtClusters.get_clusters(with_proxy=True)
        self.ctx["odin_checks"] = {}
        self.ctx["odin_checks_order"] = []
        for check_name in self._list_checks():
            check_description = " ".join([word.capitalize() for word in check_name.split("_")])
            self.ctx["odin_checks"][check_name] = check_description
            self.ctx["odin_checks_order"].append(check_name)
        self.ctx["odin_checks_order"].sort()
        if "sort_result" in self.ctx["odin_checks_order"]:
            self.ctx["odin_checks_order"].insert(
                0, self.ctx["odin_checks_order"].pop(self.ctx["odin_checks_order"].index("sort_result")))

    def build_configs(self):
        template = self._load_json(self.ctx["config_template"])

        for cluster, proxy in self.ctx["yt_clusters"]:
            if cluster in self.ctx["skip_clusters"]:
                continue
            new_section = {
                "{}".format(cluster): {
                    "db_config": {
                        "options": {
                            "cluster": cluster
                        }
                    }
                }
            }
            old_section = template["clusters"].get(cluster, None)
            if old_section:
                new_section[cluster].update(old_section)
            template["clusters"].update(new_section)

        for k in self.ctx["odin_checks_order"]:
            template["services"].append({"name": k, "display_name": self.ctx["odin_checks"][k]})
        self.ctx["config"] = template
