# -*- coding: utf-8

import sandbox.common.types.task as ctt

from sandbox import sdk2
from sandbox.projects.yt.common.tasks.YtBuildYaPackage import YtBuildYaPackage

from sandbox.projects.common.nanny import nanny


class YtBuildDocPackage(YtBuildYaPackage):
    """
    Build tarball with Documentation site
    """
    class CustomParameters(YtBuildYaPackage.CustomParameters):
        use_aapi_fuse = True
        package_path = "yt/docs/package/pkg.json"
        output_resource = "YT_DOC_PACKAGE_RESOURCE"
        checkout_mode = "auto"

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
        nanny.ReleaseToNannyTask2.on_release(self, dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject="YT DOC RELEASE",
            email_notifications=dict(to=[self.author], cc=[]),
            release_comments="YT DOC RELEASE",
        ))
