# -*- coding: utf-8

from sandbox import sdk2
from sandbox.projects.yt.common.tasks.YtBuildYaPackage import YtBuildYaPackage


class YtBuildTransferManagerPackage(YtBuildYaPackage):
    """
    Build tarball with Transfer Manager binaries
    """
    class CustomParameters(YtBuildYaPackage.CustomParameters):
        package_path = "transfer_manager/server/package.json"

    # Override run subtask method
    def _run_sub_task(self):
        ya_package_task = sdk2.Task["YA_PACKAGE"](
            self,
            description=self.CustomParameters.description,
            checkout_arcadia_from_url=self.Parameters.arcadia_url,
            packages=self.CustomParameters.package_path,
            use_new_format=True,
            package_type=self.CustomParameters.package_type,
            compress_package_archive=True,
            resource_type=self.CustomParameters.output_resource,
            force_dupload=self.CustomParameters.force_dupload,
            publish_package=self.CustomParameters.publish_package,
            publish_to=self.CustomParameters.publish_to,
            key_user=self.CustomParameters.key_user,
            arcadia_patch=self.Parameters.arcadia_patch,
            checkout=False,
            checkout_mode="auto",
            use_aapi_fuse=self.CustomParameters.use_aapi_fuse,
        )
        ya_package_task.Requirements.disk_space = self.Requirements.disk_space
        return ya_package_task.save().enqueue()
